<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:plugin="http://www.ametys.org/schema/plugin"
                exclude-result-prefixes="plugin">
                
	<xsl:template match="CMS">
		<xsl:apply-templates select="ribbon"/>
	</xsl:template>        
	
	<xsl:template match="ribbon">
		<ribbon xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
			<xsl:apply-templates select="tab"/>
			
			<!-- New tabs -->
			<xsl:for-each select="/CMS/parameters/tab[not(@id = /CMS/ribbon/tab/@id)]">
				<tab label="{@label}" i18n:attr="" id="{@id}" contextualGroup="K" contextualColor="3" contextualLabel="plugin.skinfactory:RIBBON_TABS_TAB_SKINFACTORY_GROUP_LABEL">
					<groups>
						<xsl:for-each select="groups/group">
							<group label="{@label}" i18n:attr="label" icon="" id="{concat(../../@label, '.', @label)}" >
								<xsl:call-template name="new-layout-large"/>
								<xsl:call-template name="new-layout-medium"/>
								<xsl:call-template name="new-layout-small"/>
							</group>
						</xsl:for-each>
					</groups>
				</tab>	
			</xsl:for-each>
		</ribbon>
	</xsl:template>
	
	<xsl:template match="tab">
		<tab>
			<xsl:copy-of select="@*"/>
			
			<xsl:variable name="tabId" select="@id"/>
			<groups>
				<xsl:apply-templates select="groups/group">
					<xsl:with-param name="tabId" select="$tabId"/>
				</xsl:apply-templates>
				
				<!-- New groups of same tab -->
				<xsl:for-each select="/CMS/parameters/tab[@id = $tabId]/groups/group[not(@id = /CMS/ribbon/tab[@id = $tabId]/groups/group/@id)]">
					<xsl:if test="parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]">
						<group label="{@label}" i18n:attr="" icon="" id="{concat(../../@label, '.', @label)}">
							<large></large>
							<xsl:call-template name="new-layout-medium"/>
							<small></small>
						</group>
					</xsl:if>
				</xsl:for-each>
			</groups>
			
		</tab>
	</xsl:template>  
	
	<xsl:template match="group">
		<xsl:param name="tabId"/>
		
		<group>
			<xsl:copy-of select="@*"/>
			
			<xsl:apply-templates select="large|medium|small">
				<xsl:with-param name="tabId" select="$tabId"/>
				<xsl:with-param name="groupLabel" select="@label"/>
				<xsl:with-param name="groupId" select="@id"/>
			</xsl:apply-templates>
		</group>
	</xsl:template>  
	
	<xsl:template match="large|small">
	</xsl:template>
	
	<xsl:template match="large|medium|small">
		<xsl:param name="tabId"/>
		<xsl:param name="groupLabel"/>
		<xsl:param name="groupId"/>
		
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			
			<xsl:apply-templates select="layout|parameter|menu|comment()">
				<xsl:with-param name="tabId" select="$tabId"/>
				<xsl:with-param name="groupLabel" select="$groupLabel"/>
				<xsl:with-param name="groupId" select="$groupId"/>
			</xsl:apply-templates>
			
			<!-- New parameters or menus of same tab and group -->
			<xsl:if test="layout|parameter|menu">
				<xsl:apply-templates select="/CMS/parameters/tab[@id = $tabId]/groups/group[@id = $groupId]/parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|/CMS/parameters/tab[@id = $tabId]/groups/group[@id = $groupId]/menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]" mode="new">
					<xsl:sort select="@id"/>
				</xsl:apply-templates>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="layout">
		<xsl:param name="tabId"/>
		<xsl:param name="groupLabel"/>
		<xsl:param name="groupId"/>
		
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			
			<xsl:apply-templates select="parameter|menu|comment()">
				<xsl:with-param name="tabId" select="$tabId"/>
				<xsl:with-param name="groupLabel" select="$groupLabel"/>
				<xsl:with-param name="groupId" select="$groupId"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template name="new-layout-large">
		<large>
			<!-- <xsl:apply-templates select="parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]" mode="new">
				<xsl:sort select="@id"/>
			</xsl:apply-templates> -->
		</large>
	</xsl:template>
	
	<xsl:template name="new-layout-medium">
		<medium>
			<layout size="small" cols="{ceiling(count(parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]) div 3)}">
				<xsl:apply-templates select="parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]" mode="new">
					<xsl:sort select="@id"/>
				</xsl:apply-templates>
			</layout>
		</medium>
	</xsl:template>
	
	<xsl:template name="new-layout-small">
		<small>
			<!-- <layout size="very-small" cols="{ceiling(count(parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]) div 3)}">
				<xsl:apply-templates select="parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]" mode="new">
					<xsl:sort select="@id"/>
				</xsl:apply-templates>
			</layout> -->
		</small>
	</xsl:template>
	
	<xsl:template match="parameter" mode="new">
		<parameter id="{@id}"/>
	</xsl:template>
	
	<xsl:template match="parameter">
		<xsl:variable name="id" select="@id"/>
		<xsl:choose>
			<xsl:when test="/CMS/parameters//parameter[@id = $id]">
				<parameter id="{$id}"/>
			</xsl:when>
			<xsl:otherwise>
				<!-- Old parameter -->
				<xsl:comment><xsl:text>parameter id="</xsl:text><xsl:value-of select="$id"/><xsl:text>"/</xsl:text></xsl:comment>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="menu" mode="new">
		<menu label="{@label}" i18n:attr="" id="{@id}">
			<xsl:if test="@iconGlyph">
				<xsl:attribute name="icon-glyph"><xsl:value-of select="@iconGlyph"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@iconSmall">
				<xsl:attribute name="icon-small"><xsl:value-of select="@iconSmall"/></xsl:attribute>
				<xsl:attribute name="icon-medium"><xsl:value-of select="@iconLarge"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]" mode="new">
				<xsl:sort select="@id"/>
			</xsl:apply-templates>
		</menu>
	</xsl:template>
	
	<xsl:template match="menu">
		<xsl:param name="tabId"/>
		<xsl:param name="groupLabel"/>
		<xsl:param name="groupId"/>
		
		<xsl:variable name="currentMenuId" select="@id"/>
		
		<menu>
			<xsl:copy-of select="@*"/>
			
			<xsl:apply-templates select="parameter|menu|comment()">
				<xsl:with-param name="tabId" select="$tabId"/>
				<xsl:with-param name="groupLabel" select="$groupLabel"/>
				<xsl:with-param name="groupId" select="$groupId"/>
			</xsl:apply-templates>
			
			<!-- New parameters of same tab, group and menu -->
			<xsl:apply-templates select="/CMS/parameters/tab[@id = $tabId]/groups/group[@id = $groupId]//menu[@id = $currentMenuId]/parameter[not(@id = /CMS/ribbon/tab/groups/group//parameter/@id)]|/CMS/parameters/tab[@id = $tabId]/groups/group[@id = $groupId]//menu[@id = $currentMenuId]/menu[not(@id = /CMS/ribbon/tab/groups/group//menu/@id)]" mode="new"/>
		</menu>
	</xsl:template>
	
	<xsl:template match="comment()">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="*">
		<xsl:copy>
			<xsl:copy-of select="@*"></xsl:copy-of>
		
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	
</xsl:stylesheet>