/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * I18n Input text field controller for the ribbon
 */
Ext.define('Ametys.plugins.skinfactory.widgets.controller.I18nInputText', {
	extend: 'Ametys.ribbon.element.ui.FieldController',
	
	constructor: function (config)
	{
		config = Ext.applyIf (config, {
			'width': 350,
			'width-small': 250,
			'width-very-small': 190,
			'label-width': 70,
			'input-xtype': 'i18ninputtext'
		});
		
		this.callParent(arguments);
		
		Ametys.message.MessageBus.on(Ametys.message.Message.LOADED, this._onSkinLoaded, this);
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onChangeLanguage, this);
	},
	
	createUI: function(size, colspan)
	{
		var element = this.callParent(arguments);
		
		element.labelAlign = "right";
		
		element.on("change", this._onChange, this);
		element.on("specialkey", this._onSpecialKey, this);
		return element;
	},
	
	/**
	 * @private
	 * Listener on the change value event. 
	 * @param {Ametys.plugins.skinfactory.widgets.field.I18nInputTextField} field The field
	 */
	_onChange: function (field)
	{
		this._saveValue(field);
	},
	
	/**
	 * @private
	 * Listener on 'specialkey' event. Save the value of the field if press ENTER
	 * @param {Ametys.plugins.skinfactory.widgets.field.I18nInputTextField} field The field
     * @param {Ext.event.Event} e The event
	 */
	_onSpecialKey: function (field, e)
	{
		if (e.getKey() == e.ENTER) 
		{
			this._saveValue(field);
	    }
	},
	
	/**
	 * @private
	 * Save the current value
	 * @param {Ametys.plugins.skinfactory.widgets.field.I18nInputTextField} field The field
	 */
	_saveValue: function (field)
	{
		var lang = field.getCurrentLanguage();
		if (lang)
		{
			var value = field.getValue();
			Ametys.plugins.skinfactory.skin.SkinActions.updateParameter(this.getInitialConfig("paramId"), value[lang], lang);
			
			this._hasChanges = false;
		}
	},
	
	/**
	 * @private
	 * Listener when the skin was loaded. Update the field value.
	 * @param  {Ametys.plugins.skinfactory.widgets.field.I18nInputTextField} field The i18n input field.
	 */
	_onSkinLoaded: function ()
	{
		var currentLanguage = Ametys.plugins.skinfactory.SkinParametersManager.getCurrentLanguage();
		var value = Ametys.plugins.skinfactory.SkinParametersManager.getParameterValue(this.getInitialConfig("paramId"));
		
		if (value && value[currentLanguage] !== undefined)
		{
			this.setValue(value);
		}
	},
	
	/**
	 * @private
	 * Listener when the skin language has changed
	 * @param  {Ametys.message.Message} message The language modified message
	 */
	_onChangeLanguage: function (message)
	{
		var target = message.getTarget(Ametys.message.MessageTarget.SKIN_LANGUAGE);
		if (target != null)
		{
			this.getUIControls().each(function (input) {
				// Prevent onchange event
				input.suspendEvent('change');
				input.setLanguage(target.getParameters().lang);
				input.resumeEvent('change');
			});
		}
	}
	
});
