/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Menu for the text alignement widgets
 */
Ext.define('Ametys.plugins.skinfactory.widgets.menu.TextAlignMenu', {
	extend: 'Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu',
	
	constructor: function (config) 
	{
		config = Ext.applyIf(config, {
			cssStyle: 'text-align',
			items: [
				Ext.create("Ext.menu.CheckItem", {
					text: "{{i18n PLUGINS_SKINFACTORY_ALIGN_LEFT}}", 
					value: "left", 
					iconCls: 'ametysicon-alignment',
					
					showCheckbox: false,
					checkHandler: Ext.bind(this._onPress, this)
				}),
				Ext.create("Ext.menu.CheckItem", {
					text: "{{i18n PLUGINS_SKINFACTORY_ALIGN_CENTER}}", 
					value: "center", 
					iconCls: 'ametysicon-alignment1',
					showCheckbox: false,
					checkHandler: Ext.bind(this._onPress, this)
				}),
				Ext.create("Ext.menu.CheckItem", {
					text: "{{i18n PLUGINS_SKINFACTORY_ALIGN_RIGHT}}", 
					value: "right", 
					iconCls: 'ametysicon-right-alignment',
					showCheckbox: false,
					checkHandler: Ext.bind(this._onPress, this)
				}),
				Ext.create("Ext.menu.CheckItem", {
					text: "{{i18n PLUGINS_SKINFACTORY_ALIGN_JUSTIFY}}", 
					value: "justify", 
					iconCls: "ametysicon-text152",
					showCheckbox: false,
					checkHandler: Ext.bind(this._onPress, this)
				})
			]
		});
		
		this.callParent(arguments);
	}
	
});
	