/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.filefilter.FileFilter;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.CSSColorParameter;
import org.ametys.skinfactory.parameters.CSSParameter;
import org.ametys.skinfactory.parameters.I18nizableTextParameter;
import org.ametys.skinfactory.parameters.ImageParameter;
import org.ametys.skinfactory.parameters.TextParameter;
import org.ametys.skinfactory.parameters.Variant;
import org.ametys.skinfactory.parameters.VariantParameter;
import org.ametys.web.skin.SkinModel;
import org.ametys.web.skin.SkinModelsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;

public class SkinFactoryComponent
extends AbstractLogEnabled
implements Component,
ThreadSafe,
Serviceable {
    public static final String ROLE = SkinFactoryComponent.class.getName();
    public static final Pattern CSS_PARAM_PATTERN = Pattern.compile("\\s*([^,:\\s]*)\\s*:\\s*([^:;!]*)\\s*(?:!important)?\\s*\\/\\*\\s*AMETYS\\s*\\(\\s*\"([^\"]+)\"\\s*(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?\\)\\s*\\*\\/\\s*;?\\s*", 8);
    public static final Pattern I18N_PARAM_PATTERN = Pattern.compile("^\\s*<message key=\"([^,:\\s]*)\">([^<]*)<!--\\s*AMETYS\\s*\\(\\s*\"([^\"]+)\"\\s*(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?\\)\\s*--></message>\\s*$", 8);
    public static final Pattern TXT_PARAM_PATTERN = Pattern.compile("^[^>]*>([^<]*)<!--\\s*AMETYS\\s*\\(\\s*\"([^\"]+)\"\\s*(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?(?:,\\s*([^,\"\\s]+|\"[^\"]*\")\\s*)?\\)\\s*-->.*$", 8);
    private static final Pattern __I18N_CATALOG_LANGUAGE = Pattern.compile("^\\s*<catalogue xml:lang=\"([a-z]{2})\">\\s*$", 8);
    private final Map<String, Map<String, AbstractSkinParameter>> _modelsParameters = new HashMap<String, Map<String, AbstractSkinParameter>>();
    private final Map<String, String> _modelsHash = new HashMap<String, String>();
    private SkinModelsManager _modelsManager;
    private SourceResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._modelsManager = (SkinModelsManager)smanager.lookup(SkinModelsManager.ROLE);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void clearModelsParametersCache() {
        this._modelsParameters.clear();
    }

    public AbstractSkinParameter getModelParamater(String modelName, String paramId) {
        Map<String, AbstractSkinParameter> modelParameters = this.getModelParameters(modelName);
        return modelParameters.get(paramId);
    }

    public boolean isModelUpToDate(String modelName) {
        String hash = this._modelsManager.getModelHash(modelName);
        if (!this._modelsHash.containsKey(modelName) || !this._modelsHash.get(modelName).equals(hash)) {
            this._modelsHash.put(modelName, hash);
            return false;
        }
        return true;
    }

    public Map<String, AbstractSkinParameter> getModelParameters(String modelName) {
        try {
            if (!this.isModelUpToDate(modelName)) {
                this._modelsParameters.remove(modelName);
            }
            if (this._modelsParameters.containsKey(modelName)) {
                return this._modelsParameters.get(modelName);
            }
            this._modelsParameters.put(modelName, new LinkedHashMap());
            Map<String, AbstractSkinParameter> skinParams = this._modelsParameters.get(modelName);
            Path modelDir = this._modelsManager.getModel(modelName).getPath();
            skinParams.putAll(this._getVariantParameters(modelDir, modelName));
            skinParams.putAll(this._getImageParameters(modelDir, modelName));
            skinParams.putAll(this._getCSSParameters(modelDir, modelName));
            skinParams.putAll(this._getI18nTextParameters(modelDir, modelName));
            skinParams.putAll(this._getTextParameters(modelDir, modelName));
            return skinParams;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find parameters for model " + modelName, e);
        }
    }

    private Map<String, VariantParameter> _getVariantParameters(Path modelDir, String modelName) throws IOException {
        HashMap<String, VariantParameter> params = new HashMap<String, VariantParameter>();
        Path variantsDir = modelDir.resolve("model/variants");
        if (Files.exists(variantsDir, new LinkOption[0])) {
            this._findVariantsParameters(variantsDir, params, modelName);
        }
        return params;
    }

    private void _findVariantsParameters(Path variantsDir, Map<String, VariantParameter> params, String modelName) throws IOException {
        try (Stream<Path> files = Files.list(variantsDir);){
            files.filter(FileFilter.getSkinDirectoryFilter()).forEach(child -> {
                String filename = child.getFileName().toString();
                List<Variant> values = this._getVariantValues((Path)child, modelName);
                if (values.size() != 0) {
                    VariantParameter variantParameter = new VariantParameter(filename, new I18nizableText(filename), new I18nizableText(""), values);
                    this._configureVariant((Path)child, variantParameter, modelName);
                    params.put(variantParameter.getId(), variantParameter);
                } else {
                    this.getLogger().debug("Discarding variant " + child.toAbsolutePath().toString() + " because it has no sub directories as values");
                }
            });
        }
    }

    private List<Variant> _getVariantValues(Path variant, String modelName) {
        ArrayList<Variant> values = new ArrayList<Variant>();
        try (Stream<Path> files = Files.list(variant);){
            files.filter(FileFilter.getSkinDirectoryFilter()).forEach(child -> {
                String id = child.getFileName().toString();
                String thumbnailPath = null;
                Path thumbnailFile = child.resolve(id + ".png");
                if (Files.exists(thumbnailFile, new LinkOption[0])) {
                    thumbnailPath = variant.getParent().relativize(thumbnailFile).toString();
                }
                I18nizableText label = new I18nizableText(id);
                I18nizableText description = new I18nizableText("");
                Path file = child.resolve(id + ".xml");
                if (Files.exists(file, new LinkOption[0])) {
                    try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                        Configuration configuration = new DefaultConfigurationBuilder().build(is);
                        label = this._configureI18nizableText(configuration.getChild("label"), modelName);
                        description = this._configureI18nizableText(configuration.getChild("description"), modelName);
                    }
                    catch (Exception e) {
                        this.getLogger().error("Unable to configure variant '" + id + "'", (Throwable)e);
                    }
                }
                values.add(new Variant(id, label, description, thumbnailPath));
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get variants from " + variant.toAbsolutePath().toString(), e);
        }
        return values;
    }

    private void _configureVariant(Path variantFile, VariantParameter param, String modelName) {
        File iconLarge;
        File iconSmall;
        Path file = variantFile.resolve(variantFile.getFileName().toString() + ".xml");
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                Configuration configuration = new DefaultConfigurationBuilder().build(is);
                I18nizableText label = this._configureI18nizableText(configuration.getChild("label"), modelName);
                param.setLabel(label);
                I18nizableText description = this._configureI18nizableText(configuration.getChild("description"), modelName);
                param.setDescription(description);
                param.setIconGlyph(configuration.getChild("icon-glyph").getValue(null));
            }
            catch (Exception e) {
                this.getLogger().error("Unable to configure variant '" + param.getId() + "'", (Throwable)e);
            }
        }
        if ((iconSmall = new File(String.valueOf(variantFile) + "/thumbnail_16.png")).exists()) {
            param.setIconSmall(iconSmall.getName());
        }
        if ((iconLarge = new File(String.valueOf(variantFile) + "/thumbnail_32.png")).exists()) {
            param.setIconLarge(iconLarge.getName());
        }
    }

    private Map<String, ImageParameter> _getImageParameters(Path modelDir, String modelName) {
        HashMap<String, ImageParameter> params = new HashMap<String, ImageParameter>();
        Path imagesDir = modelDir.resolve("model/images");
        if (Files.exists(imagesDir, new LinkOption[0])) {
            this._findImagesParameters(modelDir, imagesDir, imagesDir, params, modelName);
        }
        return params;
    }

    private void _findImagesParameters(Path modelDir, Path imagesDir, Path file, Map<String, ImageParameter> params, String modelName) {
        try (Stream<Path> files = Files.list(file);){
            files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(child -> {
                String filename = child.getFileName().toString();
                String lcFilename = filename.toLowerCase();
                if (lcFilename.endsWith(".png") || lcFilename.endsWith(".jpg") || lcFilename.endsWith(".jpeg") || lcFilename.endsWith(".gif")) {
                    String imagePath = imagesDir.relativize((Path)child).toString();
                    ImageParameter imageParameter = new ImageParameter(imagePath, new I18nizableText(filename), new I18nizableText(""));
                    this._configureImage((Path)child, imageParameter, modelName);
                    params.put(imageParameter.getId(), imageParameter);
                } else {
                    this._findImagesParameters(modelDir, imagesDir, (Path)child, params, modelName);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find images parameters in directory " + imagesDir.toString(), e);
        }
    }

    private void _configureImage(Path imageFile, ImageParameter param, String modelName) {
        Path iconLarge;
        Path iconSmall;
        Path file;
        String filename = imageFile.getFileName().toString();
        int i = filename.lastIndexOf(".");
        if (i > 0) {
            filename = filename.substring(0, i);
        }
        if (Files.exists(file = imageFile.resolve(filename + ".xml"), new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                Configuration configuration = new DefaultConfigurationBuilder().build(is);
                I18nizableText label = this._configureI18nizableText(configuration.getChild("label"), modelName);
                param.setLabel(label);
                I18nizableText description = this._configureI18nizableText(configuration.getChild("description"), modelName);
                param.setDescription(description);
                param.setIconGlyph(configuration.getChild("icon-glyph").getValue(null));
            }
            catch (Exception e) {
                this.getLogger().error("Unable to configure image parameter '" + param.getId() + "'", (Throwable)e);
            }
        }
        if (Files.exists(iconSmall = imageFile.resolve("thumbnail_16.png"), new LinkOption[0])) {
            param.setIconSmall(iconSmall.getFileName().toString());
        }
        if (Files.exists(iconLarge = imageFile.resolve("thumbnail_32.png"), new LinkOption[0])) {
            param.setIconLarge(iconLarge.getFileName().toString());
        }
    }

    private Map<String, CSSParameter> _getCSSParameters(Path modelDir, String modelName) throws IOException {
        HashMap<String, CSSParameter> cssParams = new HashMap<String, CSSParameter>();
        for (Path file : this._listFiles(modelDir.resolve("resources"), "css")) {
            this._parseCSSFile(cssParams, modelName, file);
        }
        Path templatesDir = modelDir.resolve("templates");
        if (Files.isDirectory(templatesDir, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(templatesDir);){
                files.forEach(template -> {
                    for (Path file : this._listFiles(template.resolve("resources"), "css")) {
                        this._parseCSSFile(cssParams, modelName, file);
                    }
                });
            }
        }
        for (Path file : this._listFiles(modelDir, "xsl")) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            this._parseCSSFile(cssParams, modelName, file);
        }
        return cssParams;
    }

    private List<Path> _listFiles(Path file, String extension) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                return Files.walk(file, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().endsWith("." + extension)).collect(Collectors.toList());
            }
            return Collections.EMPTY_LIST;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot list " + extension + " files in " + file.toString(), e);
        }
    }

    private void _parseCSSFile(Map<String, CSSParameter> cssParams, String modelName, Path cssFile) {
        try (InputStream is = Files.newInputStream(cssFile, new OpenOption[0]);){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            Matcher m = CSS_PARAM_PATTERN.matcher(string);
            while (m.find()) {
                CSSParameter cssParameter;
                I18nizableText description;
                String id = m.group(3);
                if (cssParams.containsKey(id)) {
                    I18nizableText description2;
                    I18nizableText label;
                    CSSParameter cssParameter2 = cssParams.get(id);
                    cssParameter2.addCSSFile(cssFile);
                    I18nizableText i18nizableText = label = m.group(4) != null ? this._parseI18nizableText(m.group(4), modelName) : null;
                    if (label != null) {
                        cssParameter2.setLabel(label);
                    }
                    if ((description2 = m.group(5) != null ? this._parseI18nizableText(m.group(5), modelName) : null) == null) continue;
                    cssParameter2.setDescription(description2);
                    continue;
                }
                String cssProperty = m.group(1);
                String defaultValue = m.group(2).trim();
                I18nizableText label = m.group(4) != null ? this._parseI18nizableText(m.group(4), modelName) : null;
                I18nizableText i18nizableText = description = m.group(5) != null ? this._parseI18nizableText(m.group(5), modelName) : null;
                if (cssProperty.equals("color") || cssProperty.equals("background-color") || cssProperty.equals("border-color")) {
                    cssParameter = new CSSColorParameter(id, label, description, cssFile, cssProperty, defaultValue, this._modelsManager.getModel(modelName), this);
                    cssParams.put(id, cssParameter);
                    continue;
                }
                cssParameter = new CSSParameter(id, label, description, cssFile, cssProperty, defaultValue);
                cssParams.put(id, cssParameter);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to parse file '" + cssFile.getFileName().toString() + "'", (Throwable)e);
        }
    }

    private Map<String, TextParameter> _getTextParameters(Path modelDir, String modelName) {
        HashMap<String, TextParameter> textParams = new HashMap<String, TextParameter>();
        for (Path file : this._listFiles(modelDir, "xsl")) {
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            textParams.putAll(this._parseXSLFile(modelName, file));
        }
        return textParams;
    }

    private Map<String, TextParameter> _parseXSLFile(String skinName, Path xslFile) {
        LinkedHashMap<String, TextParameter> txtParams = new LinkedHashMap<String, TextParameter>();
        try (InputStream is = Files.newInputStream(xslFile, new OpenOption[0]);){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            Matcher m = TXT_PARAM_PATTERN.matcher(string);
            while (m.find()) {
                String id = m.group(2);
                String defaultValue = m.group(1);
                I18nizableText label = m.group(3) != null ? this._parseI18nizableText(m.group(3), skinName) : new I18nizableText(id);
                I18nizableText description = m.group(4) != null ? this._parseI18nizableText(m.group(4), skinName) : new I18nizableText("");
                TextParameter txtParam = new TextParameter(id, label, description, xslFile, defaultValue);
                txtParams.put(id, txtParam);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to parse file '" + xslFile.getFileName().toString() + "'", (Throwable)e);
        }
        return txtParams;
    }

    private Map<String, I18nizableTextParameter> _getI18nTextParameters(Path modelDir, String modelName) {
        HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>();
        Path file = modelDir.resolve("i18n/messages.xml");
        if (Files.exists(file, new LinkOption[0])) {
            i18nParams.putAll(this._parseI18nFile(modelName, file));
        }
        return i18nParams;
    }

    private Map<String, I18nizableTextParameter> _parseI18nFile(String skinName, Path i18nFile) {
        LinkedHashMap<String, I18nizableTextParameter> i18nParams = new LinkedHashMap<String, I18nizableTextParameter>();
        try (InputStream is = Files.newInputStream(i18nFile, new OpenOption[0]);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String defaultLang = this._getCatalogLanguage(string, i18nFile.getFileName().toString());
            Matcher m = I18N_PARAM_PATTERN.matcher(string);
            while (m.find()) {
                String i18nKey = m.group(1);
                String defaultValue = m.group(2).trim();
                String id = m.group(3);
                I18nizableText label = m.group(4) != null ? this._parseI18nizableText(m.group(4), skinName) : new I18nizableText(id);
                I18nizableText description = m.group(5) != null ? this._parseI18nizableText(m.group(5), skinName) : new I18nizableText("");
                HashMap<String, String> defaultValues = new HashMap<String, String>();
                defaultValues.put(defaultLang, defaultValue);
                defaultValues.putAll(this._getI18nOtherDefaultValues(i18nFile, i18nKey));
                I18nizableTextParameter i18nParam = new I18nizableTextParameter(id, label, description, i18nKey, defaultValues);
                i18nParams.put(id, i18nParam);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to parse file '" + i18nFile.getFileName().toString() + "'", (Throwable)e);
        }
        return i18nParams;
    }

    private String _getCatalogLanguage(String string, String fileName) {
        Matcher m = __I18N_CATALOG_LANGUAGE.matcher(string);
        if (m.find()) {
            return m.group(1);
        }
        if (fileName.startsWith("messages_")) {
            return fileName.substring("messages_".length(), 2);
        }
        return "en";
    }

    private Map<String, String> _getI18nOtherDefaultValues(Path defaultCatalog, String i18nKey) throws IOException {
        Pattern pattern = Pattern.compile("^\\s*<message key=\"" + i18nKey + "\">([^<]*)</message>\\s*$", 8);
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        try (Stream<Path> files = Files.list(defaultCatalog.getParent());){
            files.filter(f -> !f.equals(defaultCatalog)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().startsWith("messages")).forEach(file -> {
                try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                    String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    String lang = this._getCatalogLanguage(string, file.getFileName().toString());
                    Matcher m = pattern.matcher(string);
                    if (m.find()) {
                        String value = m.group(1);
                        defaultValues.put(lang, value);
                    }
                }
                catch (IOException e) {
                    this.getLogger().error("Unable to parse file '" + file.getFileName().toString() + "'", (Throwable)e);
                }
            });
        }
        return defaultValues;
    }

    private I18nizableText _parseI18nizableText(String label, String modelName) {
        if (label.startsWith("\"") && label.endsWith("\"")) {
            return new I18nizableText(label.substring(1, label.length() - 1));
        }
        return new I18nizableText("model." + modelName, label);
    }

    public Object getParameterValue(Path skinDir, String modelName, String id) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        return this.getParameterValues(skinDir, modelName, ids).get(id);
    }

    public Map<String, Object> getParameterValues(Path skinDir, String modelName, List<String> ids) {
        HashMap<String, Object> hashMap;
        block11: {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Path modelFile = skinDir.resolve("model.xml");
            InputStream is = Files.newInputStream(modelFile, new OpenOption[0]);
            try {
                Configuration[] parametersConf;
                Configuration configuration = new DefaultConfigurationBuilder(true).build(is);
                for (Configuration paramConf : parametersConf = configuration.getChild("parameters").getChildren("parameter")) {
                    String id = paramConf.getAttribute("id");
                    if (!ids.contains(id)) continue;
                    AbstractSkinParameter modelParam = this.getModelParamater(modelName, id);
                    if (modelParam instanceof I18nizableTextParameter) {
                        Configuration[] children = paramConf.getChildren();
                        HashMap<String, String> langValues = new HashMap<String, String>();
                        for (Configuration langConfig : children) {
                            langValues.put(langConfig.getName(), langConfig.getValue(""));
                        }
                        values.put(id, langValues);
                        continue;
                    }
                    values.put(id, paramConf.getValue(""));
                }
                hashMap = values;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to get values for parameters '" + StringUtils.join(ids, (String)", ") + "'", (Throwable)e);
                    return new HashMap<String, Object>();
                }
            }
            is.close();
        }
        return hashMap;
    }

    public String getColorTheme(Path skinDir) {
        String string;
        block8: {
            Path modelFile = skinDir.resolve("model.xml");
            InputStream is = Files.newInputStream(modelFile, new OpenOption[0]);
            try {
                Configuration configuration = new DefaultConfigurationBuilder(true).build(is);
                string = configuration.getChild("color-theme").getValue(null);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to get theme value", (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public Map<String, Object> getParameterValues(Path skinDir, String modelName) {
        HashMap<String, Object> hashMap;
        block12: {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Path modelFile = skinDir.resolve("model.xml");
            InputStream is = Files.newInputStream(modelFile, new OpenOption[0]);
            try {
                Configuration configuration = new DefaultConfigurationBuilder(true).build(is);
                Configuration[] parametersConf = configuration.getChild("parameters").getChildren("parameter");
                Map<String, AbstractSkinParameter> modelParameters = this.getModelParameters(modelName);
                for (Configuration paramConf : parametersConf) {
                    String id = paramConf.getAttribute("id");
                    AbstractSkinParameter modelParam = modelParameters.get(id);
                    if (modelParam == null) continue;
                    if (modelParam instanceof I18nizableTextParameter) {
                        Configuration[] children = paramConf.getChildren();
                        HashMap<String, String> langValues = new HashMap<String, String>();
                        for (Configuration langConfig : children) {
                            langValues.put(langConfig.getName(), langConfig.getValue(""));
                        }
                        values.put(id, langValues);
                        continue;
                    }
                    if (modelParam instanceof ImageParameter) {
                        boolean uploaded = Boolean.valueOf(paramConf.getAttribute("uploaded", "false"));
                        values.put(id, new ImageParameter.FileValue(paramConf.getValue(""), uploaded));
                        continue;
                    }
                    values.put(id, paramConf.getValue(""));
                }
                hashMap = values;
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("Unable to get values of all parameters", (Throwable)e);
                    return new HashMap<String, Object>();
                }
            }
            is.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveColorTheme(Path skinDir, String themeId) {
        boolean bl;
        Path currentFile = skinDir.resolve("model.xml");
        Source currentSrc = null;
        Source src = null;
        try {
            currentSrc = this._resolver.resolveURI("file://" + currentFile.toFile().getAbsolutePath());
            HashMap<String, String> parentContext = new HashMap<String, String>();
            parentContext.put("modelUri", currentSrc.getURI());
            if (themeId != null) {
                parentContext.put("themeId", themeId);
            }
            src = this._resolver.resolveURI("cocoon://_plugins/skinfactory/change-color-theme", null, parentContext);
            SourceUtil.copy((Source)src, (Source)currentSrc);
            bl = true;
            this._resolver.release(src);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to update color theme for skin '" + skinDir.getFileName().toString() + "'", (Throwable)e);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this._resolver.release(src);
            this._resolver.release(currentSrc);
        }
        this._resolver.release(currentSrc);
        return bl;
    }

    public boolean saveParameter(Path skinDir, String id, Object value) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(id, value);
        return this.saveParameters(skinDir, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveParameters(Path skinDir, Map<String, Object> parameters) {
        boolean bl;
        Path currentFile = skinDir.resolve("model.xml");
        Source currentSrc = null;
        Source src = null;
        try {
            currentSrc = this._resolver.resolveURI("file://" + currentFile.toFile().getAbsolutePath());
            HashMap<String, Object> parentContext = new HashMap<String, Object>();
            parentContext.put("modelUri", currentSrc.getURI());
            parentContext.put("skinParameters", parameters);
            src = this._resolver.resolveURI("cocoon://_plugins/skinfactory/change-parameters", null, parentContext);
            SourceUtil.copy((Source)src, (Source)currentSrc);
            bl = true;
            this._resolver.release(src);
        }
        catch (IOException e) {
            this.getLogger().error("Unable to save parameters from skin '" + skinDir.getFileName().toString() + "'", (Throwable)e);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this._resolver.release(src);
            this._resolver.release(currentSrc);
        }
        this._resolver.release(currentSrc);
        return bl;
    }

    public void applyModelParameters(String modelName, Path skinDir) {
        Map<String, Object> currentValues = this.getParameterValues(skinDir, modelName);
        this.applyModelParameters(modelName, skinDir, currentValues);
    }

    public void applyModelParameters(String modelName, Path skinDir, Map<String, Object> values) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        SkinModel model = this._modelsManager.getModel(modelName);
        Map modelDefaultValues = model.getDefaultValues();
        Map<String, AbstractSkinParameter> modelParameters = this.getModelParameters(modelName);
        for (AbstractSkinParameter skinParameter : modelParameters.values()) {
            String paramId = skinParameter.getId();
            if (skinParameter instanceof I18nizableTextParameter) {
                Map<String, String> defaultValues = ((I18nizableTextParameter)skinParameter).getDefaultValues();
                HashMap<String, String> currentValues = (HashMap<String, String>)values.get(paramId);
                if (currentValues == null) {
                    currentValues = new HashMap<String, String>();
                }
                for (String lang : defaultValues.keySet()) {
                    if (currentValues.get(lang) != null) {
                        this.applyParameter(skinParameter, skinDir, modelName, currentValues.get(lang), lang);
                        continue;
                    }
                    this.applyParameter(skinParameter, skinDir, modelName, defaultValues.get(lang), lang);
                    currentValues.put(lang, defaultValues.get(lang));
                }
                parameterValues.put(skinParameter.getId(), currentValues);
                continue;
            }
            if (skinParameter instanceof ImageParameter) {
                ImageParameter.FileValue imgValue = (ImageParameter.FileValue)this._getValue(model, skinParameter, values, modelDefaultValues);
                this.applyParameter(skinParameter, skinDir, modelName, imgValue, null);
                parameterValues.put(skinParameter.getId(), imgValue);
                continue;
            }
            String value = (String)this._getValue(model, skinParameter, values, modelDefaultValues);
            this.applyParameter(skinParameter, skinDir, modelName, value, null);
            parameterValues.put(skinParameter.getId(), value);
        }
        this.saveParameters(skinDir, parameterValues);
    }

    private Object _getValue(SkinModel model, AbstractSkinParameter param, Map<String, Object> values, Map<String, String> defaultValues) {
        String id = param.getId();
        if (values.containsKey(id)) {
            return values.get(id);
        }
        if (defaultValues.containsKey(id)) {
            String valueAsStr = defaultValues.get(id);
            if (param instanceof ImageParameter) {
                return new ImageParameter.FileValue(valueAsStr, false);
            }
            return valueAsStr;
        }
        return param.getDefaultValue(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHash(Path xmlFile, String hash) throws IOException {
        Source currentSrc = null;
        Source src = null;
        try {
            currentSrc = this._resolver.resolveURI("file://" + xmlFile.toFile().getAbsolutePath());
            HashMap<String, String> parentContext = new HashMap<String, String>();
            parentContext.put("modelUri", currentSrc.getURI());
            parentContext.put("hash", hash);
            src = this._resolver.resolveURI("cocoon://_plugins/skinfactory/change-hash", null, parentContext);
            SourceUtil.copy((Source)src, (Source)currentSrc);
        }
        catch (Throwable throwable) {
            this._resolver.release(src);
            this._resolver.release(currentSrc);
            throw throwable;
        }
        this._resolver.release(src);
        this._resolver.release(currentSrc);
    }

    public void applyParameter(AbstractSkinParameter parameter, Path skinDir, String modelName, Object value, String lang) {
        Path modelDir = this._modelsManager.getModel(modelName).getPath();
        parameter.apply(skinDir, modelDir, value, lang);
    }

    public void applyColorTheme(String modelName, Path skinDir) {
        Path modelDir = this._modelsManager.getModel(modelName).getPath();
        Map<String, Object> currentValues = this.getParameterValues(skinDir, modelName);
        Map<String, AbstractSkinParameter> modelParameters = this.getModelParameters(modelName);
        for (AbstractSkinParameter skinParameter : modelParameters.values()) {
            if (!(skinParameter instanceof CSSColorParameter)) continue;
            String value = (String)currentValues.get(skinParameter.getId());
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = (String)skinParameter.getDefaultValue(this._modelsManager.getModel(modelName));
            }
            skinParameter.apply(skinDir, modelDir, value, null);
        }
    }

    private I18nizableText _configureI18nizableText(Configuration configuration, String modelName) throws ConfigurationException {
        boolean i18nSupported = configuration.getAttributeAsBoolean("i18n", false);
        if (i18nSupported) {
            Object catalogue = configuration.getAttribute("catalogue", null);
            if (catalogue == null) {
                catalogue = "model." + modelName;
            }
            return new I18nizableText((String)catalogue, configuration.getValue());
        }
        return new I18nizableText(configuration.getValue(""));
    }
}

