/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.generators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.ametys.core.util.IgnoreRootHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ChangeModelHash
extends ServiceableGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"CMS");
        Map parentContextParameters = (Map)this.objectModel.get("parent-context");
        if (parentContextParameters != null) {
            Source src = this.resolver.resolveURI((String)parentContextParameters.get("modelUri"));
            SAXParser saxParser = null;
            try (InputStream is = src.getInputStream();){
                saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                saxParser.parse(new InputSource(is), (ContentHandler)new IgnoreRootHandler(this.contentHandler));
            }
            catch (ServiceException e) {
                throw new ProcessingException("Unable to get a SAX parser.", (Throwable)e);
            }
            finally {
                this.resolver.release(src);
                this.manager.release((Object)saxParser);
            }
            String hash = (String)parentContextParameters.get("hash");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"hash", (String)hash);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"CMS");
        this.contentHandler.endDocument();
    }
}

