/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.skinfactory.parameters;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.ametys.core.util.path.PathUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.skinfactory.filefilter.FileFilter;
import org.ametys.skinfactory.parameters.AbstractSkinParameter;
import org.ametys.skinfactory.parameters.SkinParameterException;
import org.ametys.skinfactory.parameters.Variant;
import org.ametys.web.skin.SkinModel;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class VariantParameter
extends AbstractSkinParameter {
    private String _iconGlyph;
    private String _iconSmall;
    private String _iconLarge;
    private List<Variant> _variants;

    public VariantParameter(String id, I18nizableText label, I18nizableText description, List<Variant> variants) {
        super(id, label, description);
        this._variants = variants;
    }

    public VariantParameter(String id, I18nizableText label, I18nizableText description, String iconGlyph, String iconSmall, String iconLarge, List<Variant> variants) {
        super(id, label, description);
        this._iconGlyph = iconGlyph;
        this._iconSmall = iconSmall;
        this._iconLarge = iconLarge;
        this._variants = variants;
    }

    @Override
    public AbstractSkinParameter.SkinParameterType getType() {
        return AbstractSkinParameter.SkinParameterType.VARIANT;
    }

    public List<Variant> getVariants() {
        return this._variants;
    }

    public void setIconGlyph(String iconGlyph) {
        this._iconGlyph = iconGlyph;
    }

    public String getIconGlyph() {
        return this._iconGlyph;
    }

    public void setIconSmall(String iconSmall) {
        this._iconSmall = iconSmall;
    }

    public String getIconSmall() {
        return this._iconSmall;
    }

    public void setIconLarge(String iconLarge) {
        this._iconLarge = iconLarge;
    }

    public String getIconLarge() {
        return this._iconLarge;
    }

    @Override
    public void apply(Path tempDir, Path modelDir, Object value, String lang) throws SkinParameterException {
        Path variantFile = modelDir.resolve("model/variants/" + this._id);
        Path srcFile = variantFile.resolve((String)value);
        try {
            PathUtils.copyDirectory((Path)srcFile, (Path)tempDir, FileFilter.getModelVariantFilter((String)value, srcFile), (boolean)false);
        }
        catch (IOException e) {
            throw new SkinParameterException("Unable to apply variant parameter '" + this.getId() + "'", e);
        }
    }

    @Override
    public void toSAX(ContentHandler contentHandler, String modelName) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", this.getId());
        attrs.addCDATAAttribute("type", AbstractSkinParameter.SkinParameterType.VARIANT.name().toLowerCase());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"parameter", (Attributes)attrs);
        this.getLabel().toSAX(contentHandler, "label");
        this.getDescription().toSAX(contentHandler, "description");
        if (this.getIconGlyph() != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconGlyph", (String)this.getIconGlyph());
        }
        if (this.getIconSmall() != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconSmall", (String)("/plugins/skinfactory/" + modelName + "/_thumbnail/16/16/model/variants/" + this._id + "/" + this.getIconSmall()));
        } else {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconSmall", (String)"/plugins/skinfactory/resources/img/variant_default_16.png");
        }
        if (this.getIconLarge() != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconLarge", (String)("/plugins/skinfactory/" + modelName + "/_thumbnail/32/32/model/variants/" + this._id + "/" + this.getIconLarge()));
        } else {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"iconLarge", (String)"/plugins/skinfactory/resources/img/variant_default_32.png");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"parameter");
    }

    @Override
    public Map<String, Object> toJson(String modelName) {
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        jsonObject.put("id", this.getId());
        jsonObject.put("type", AbstractSkinParameter.SkinParameterType.VARIANT.name().toLowerCase());
        jsonObject.put("label", this.getLabel());
        jsonObject.put("description", this.getDescription());
        if (this.getIconGlyph() != null) {
            jsonObject.put("iconGlyph", this.getIconGlyph());
        }
        if (this.getIconSmall() != null) {
            jsonObject.put("iconSmall", "/plugins/skinfactory/" + modelName + "/_thumbnail/16/16/model/variants/" + this._id + "/" + this.getIconSmall());
        } else {
            jsonObject.put("iconSmall", "/plugins/skinfactory/resources/img/variant_default_16.png");
        }
        if (this.getIconLarge() != null) {
            jsonObject.put("iconLarge", "/plugins/skinfactory/" + modelName + "/_thumbnail/32/32/model/variants/" + this._id + "/" + this.getIconLarge());
        } else {
            jsonObject.put("iconLarge", "/plugins/skinfactory/resources/img/variant_default_32.png");
        }
        return jsonObject;
    }

    @Override
    public String getDefaultValue(SkinModel model) {
        String string;
        block8: {
            Path variantFile = model.getPath().resolve("model/variants/" + this._id);
            Stream<Path> files = Files.list(variantFile);
            try {
                string = files.filter(FileFilter.getSkinDirectoryFilter()).findFirst().map(f -> f.getFileName().toString()).orElse(null);
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot get default value for variant " + this._id + " of model " + model.getId(), e);
                }
            }
            files.close();
        }
        return string;
    }

    @Override
    public String getDefaultValue(SkinModel model, String lang) {
        return this.getDefaultValue(model);
    }
}

