/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Generic menu for the css style depending widgets
 */
Ext.define('Ametys.plugins.skinfactory.widgets.menu.CssStyleWidgetMenu', {
	extend: 'Ext.menu.Menu',
	
	/**
	* @cfg {String} paramId The skin parameter id linked to this menu.
	*/
   
	/**
	 * @cfg {String} [cssStyle] The css style item name, to load the possible values of the skin parameter.
	 */
	
	 /**
 	 * @cfg {Ext.menu.Item[]} [items] Can be use to add some items to the menu
 	 */
	
	constructor: function (config) 
	{
		this.callParent(arguments);
		this.on('afterrender', this._onAfterRender, this);
		
		if (config.cssStyle)
		{
			this.on("show", this._onMenuShow, this);
			
			Ametys.plugins.skinfactory.SkinParametersManager.getCssStyleItems (config.cssStyle, Ext.bind(this._loadItemsCb, this));
		}
		
		if (config.items)
		{
			this.add(config.items);
		}
	},
	
	/**
	 * @private
	 * Listener invoked after rendering item.
	 * Apply the parent menu UI to the item
	 */
	_onAfterRender: function()
	{
		if (this.parentMenu && this.parentMenu.ui)
		{
			this.setUI(this.parentMenu.ui);
		}
	},
	
	/**
	 * Listener when a menu item is pressed
	 * @param {Ext.menu.Item} item The clicked item
	 */
	_onPress: function (item)
	{
		Ametys.plugins.skinfactory.skin.SkinActions.updateParameter(this.getInitialConfig("paramId"), item.value);
		// Hide all floating menu
		Ext.menu.Manager.hideAll();
	},
	
	/**
	 * Listener when the menu of the button is showed.
	 * @param {Ext.menu.Menu} menu The menu.
	 * @private
	 */
	_onMenuShow: function ()
	{
		var currentValue = Ametys.plugins.skinfactory.SkinParametersManager.getParameterValue(this.getInitialConfig("paramId"));
		
		var me = this;
		this.items.each(function (menuItem) {
			var value = menuItem.value;
			if (currentValue == value)
			{
				menuItem.setChecked(true, true);
			}
			else
			{
				menuItem.setChecked(false, true);
			}
		});
	},
	
	/**
	 * Callback after retrieving the items from the server
	 * @param {Object[]} styleItems The items configurations
	 * @private
	 */
	_loadItemsCb: function (styleItems)
	{
		var me = this;
		var items = [];
		Ext.Array.forEach(styleItems, function (styleItem) {
			if (typeof (styleItem) == 'object')
			{
				var item = Ext.create("Ext.menu.CheckItem", {
					text: styleItem.label,
					value: styleItem.value,
					
					showCheckbox: false,
					checkHandler: Ext.bind(me._onPress, me),
					checked: false,
					
					iconCls: styleItem.iconCls,
					icon: !styleItem.iconCls && styleItem.icon ? Ametys.CONTEXT_PATH + styleItem.icon : null,
					cls: styleItem.cssclass || '',
				});
				items.push(item);
			}
			else if (styleItem == 'separator')
			{
				items.push('-');
			}
		});
		
		this.add(items);
	}
});
