/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.skinfactory.actions;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinModelsManager;
import org.ametys.web.skin.SkinsManager;

/**
 * Set request attributes given by map parameters
 *
 */
public class SetRequestAttributesAction extends ServiceableAction
{
    private SkinModelsManager _modelsManager;
    private SkinsManager _skinsManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _modelsManager = (SkinModelsManager) smanager.lookup(SkinModelsManager.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        final String[] names = parameters.getNames();
        for (int i = 0; i < names.length; i++)
        {
            request.setAttribute(names[i], parameters.getParameter(names[i]));
        }
        
        String skinId = parameters.getParameter("skin");
        Skin skin = _skinsManager.getSkin(skinId);
        String model = _modelsManager.getModelOfSkin(skin);
        
        request.setAttribute("model", model);
        
        Map<String, String> result = new HashMap<>();
        result.put("model", model);
        
        return result;
    }

}
