/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.skinfactory.generators;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import org.ametys.core.util.IgnoreRootHandler;

/**
 * Generates the model file with the modifications
 */
public class ChangeModelHash extends ServiceableGenerator
{
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "CMS");
        
        Map parentContextParameters = (Map) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        if (parentContextParameters != null)
        {
            Source src = resolver.resolveURI((String) parentContextParameters.get("modelUri"));
            SAXParser saxParser = null;
            try (InputStream is = src.getInputStream())
            {
                saxParser = (SAXParser) manager.lookup(SAXParser.ROLE);
                saxParser.parse(new InputSource(is), new IgnoreRootHandler(contentHandler));
            }
            catch (ServiceException e)
            {
                throw new ProcessingException("Unable to get a SAX parser.", e);
            }
            finally
            {
                resolver.release(src);
                manager.release(saxParser);
            }
            
            String hash = (String) parentContextParameters.get("hash");
            XMLUtils.createElement(contentHandler, "hash", hash);
        }
        
        XMLUtils.endElement(contentHandler, "CMS");
        contentHandler.endDocument();
        
    }
    
}
