<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
   
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:docbook="http://docbook.org/ns/docbook" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:math="http://exslt.org/math" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
    exclude-result-prefixes="docbook"
    extension-element-prefixes="math ametys captcha">

   	<xsl:import href="plugin:web://stylesheets/helper/common.xsl"/>
    
    <xsl:variable name="uniqueId" select="concat('sendByMail_', substring-after(math:random(), '.'))"/>
    <xsl:variable name="captchaType" select="ametys:config('runtime.captcha.type')"/>
    <xsl:variable name="captchaRequired" select="ametys:isCaptchaRequired()"/>
    
    <xsl:template name="sendByMail-get-url">
        <xsl:value-of select="concat(ametys:siteUriPrefix(), '/', ametys:lang(), '/_plugins/socialnetworking/page/send-mail')"/>
    </xsl:template>
  
    <xsl:template name="sendByMailForm">
    	<xsl:param name="link-content"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_INFO" i18n:catalogue="plugin.socialnetworking"/></xsl:param>
        
        <xsl:variable name="sendByMail-page-id" select="ametys:pageId()"/>

		<xsl:variable name="sendByMail-url"><xsl:call-template name="sendByMail-get-url"/></xsl:variable>
		
        <xsl:if test="$sendByMail-page-id">
			<div class="sendByMail">
				<p id="sendByMailHeader-{$uniqueId}">
    				<a id="sendByMail-btn-{$uniqueId}" class="mailto" role="button" aria-haspopup="dialog" href="javascript: sendByMail_form_popup_{$uniqueId}()" aria-label="plugin.socialnetworking:PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_TITLE" i18n:attr="aria-label">
                        <xsl:copy-of select="$link-content"/>
                    </a>
                </p>
				
                <div id="sendByMail-{$uniqueId}" style="display: none">
    				<form id="sendByMail-form-{$uniqueId}" action="{$sendByMail-url}" method="post" class="sendByMail-form">
    					<div>
    						<input type="hidden" name="page-id" id="sendByMail-{$uniqueId}-id" value="{$sendByMail-page-id}"/>
    						<xsl:call-template name="sendByMail-form-hint"/>
    						<xsl:call-template name="sendByMail-form-field-name"/>
    						<xsl:call-template name="sendByMail-form-field-mail-by"/>
    						<xsl:call-template name="sendByMail-form-field-mail-to"/>
    						<xsl:call-template name="sendByMail-form-field-content"/>
                            <xsl:if test="$captchaRequired">
    						  <xsl:call-template name="sendByMail-form-field-captcha"/>
                            </xsl:if>					
    					</div>
    				</form>
                </div>
				
				<xsl:call-template name="sendByMail-form-script"/>
			</div>
		</xsl:if>
	</xsl:template>

    <xsl:template name="sendByMail-form-script">
        <xsl:variable name="uri-prefix">
            <xsl:call-template name="get-uri-prefix"/>
        </xsl:variable>
        
        <xsl:variable name="sendByMail-url"><xsl:call-template name="sendByMail-get-url"/></xsl:variable>
        
			<script type="text/javascript">
                sendByMail_captchaRequired_<xsl:value-of select="$uniqueId"/> = <xsl:value-of select="$captchaRequired"/>;
                
				function sendByMail_form_popup_<xsl:value-of select="$uniqueId"/>()
				{
                    if (sendByMail_captchaRequired_<xsl:value-of select="$uniqueId"/>)
                    {
					   refresh_sendByMail_<xsl:value-of select="$uniqueId"/>();
                    }
                    
					$j("#sendByMail-form-<xsl:value-of select="$uniqueId"/> script").remove();
					$j("#sendByMail-<xsl:value-of select="$uniqueId"/>").dialog({
				      resizable: false,
				      height:'auto',
				      width: 'auto',
				      modal: true,
				      title: '<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_TITLE" i18n:catalogue="plugin.socialnetworking"/>',
				      buttons: {
				        <i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SEND" i18n:catalogue="plugin.socialnetworking"/>: function() {
				          sendByMail_form_submit_<xsl:value-of select="$uniqueId"/>();
				        },
				        <i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_CANCEL" i18n:catalogue="plugin.socialnetworking"/>: function() {
				          $j(this).dialog( "close" );
                          $j("#sendByMail-btn-<xsl:value-of select="$uniqueId"/>").focus();
				        }
				      }
				    });
				    
					$j('#sendByMail-<xsl:value-of select="$uniqueId"/>-email-to').val('');
					$j('#sendByMail-<xsl:value-of select="$uniqueId"/>-text').val('');
					$j('#sendByMail-<xsl:value-of select="$uniqueId"/>-captcha').val('');
				}
                
				function sendByMail_form_submit_<xsl:value-of select="$uniqueId"/>()
				{
                    function markAsInvalid($input, msg)
                    {
                        $input.closest('.field').addClass('error');
                        $input.attr("aria-invalid", true);
                        let describedBy = $input.attr("aria-describedby") || '';
                        $input.attr("aria-describedby", describedBy.length ? describedBy + " " + $input.attr('id') + "-error" : $input.attr('id') + "-error");
                        $input.closest('.input').append(`&lt;span class="error-msg" id="${$input.attr('id')}-error"&gt;${msg}&lt;/span&gt;`);
                    }
                
                    var $dialog = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>');
					var $form = $j('#sendByMail-form-<xsl:value-of select="$uniqueId"/>');
					
					var pageId =  $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-id');
					var nameInput = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-name');
					var emailInputBy = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-email-by');
					var emailInputTo = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-email-to');
					var contentInput = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-text');
					var captchaKey = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-captcha-key');
                    var captchaInput = $j('#sendByMail-<xsl:value-of select="$uniqueId"/>-captcha');
                    
                    // Reset errors
                    $form.find(".field.error").removeClass('error');
                    $form.find(".input .error-msg").remove();
                    $form.find("[aria-invalid]").each(function() {
                        let describedBy = ($j(this).attr("aria-describedby") || '').split(' ');
                        let newDescribedBy = []
                        $j.each(describedBy, function(i, descId){
                            if (descId.indexOf("-error") == -1)
                            {
                                newDescribedBy.push(descId);
                            }
                        })
                        if (newDescribedBy.length)
                        {
                            $j(this).attr("aria-describedby", newDescribedBy.join(' '));
                        }
                        else
                        {
                            $j(this).removeAttr("aria-describedby");
                        }
                        $j(this).removeAttr("aria-invalid");
                    });
                    
                    
					var errors = false;
					
					if (/^\s*$/.test(nameInput.val()))
					{
						errors = true;
                        markAsInvalid(nameInput, "<i18n:text i18n:key="PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY" i18n:catalogue="plugin.core-ui"/>");
					}
                    
                    if (/^\s*$/.test(emailInputBy.val()))
                    {
                        errors = true;
                        markAsInvalid(emailInputBy, "<i18n:text i18n:key="PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY" i18n:catalogue="plugin.core-ui"/>");
                    }
					else if (!/^([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,})?$/.test(emailInputBy.val()))
					{
						errors = true;
                        markAsInvalid(emailInputBy, "<i18n:text i18n:key="PLUGINS_CORE_REGEXP_INVALID_MAIL" i18n:catalogue="plugin.core"/>");
					}
					
                    if (/^\s*$/.test(emailInputTo.val()))
                    {
                        errors = true;
                        markAsInvalid(emailInputTo, "<i18n:text i18n:key="PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY" i18n:catalogue="plugin.core-ui"/>");
                    }
					else if (!/^([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,})?(\s*,\s*([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,})?)*$/.test(emailInputTo.val()))
					{
						errors = true;
						markAsInvalid(emailInputTo, "<i18n:text i18n:key="PLUGINS_CORE_REGEXP_INVALID_MAIL" i18n:catalogue="plugin.core"/>");
					}
					
                    <xsl:if test="$captchaRequired and $captchaType = 'jcaptcha'">
					if (!/^[a-z]{6}$/.test(captchaInput.val()))
					{
						errors = true;
                        markAsInvalid(captchaInput, "<i18n:text i18n:key="PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY" i18n:catalogue="plugin.core-ui"/>");
					}
                    </xsl:if>
                    
                    if (errors)
                    {
                        // focus first invalid input
                        $form.find('[aria-invalid]').first().focus();
                    }
					else
					{
						// send it in ajax
						var data = {
							"page-id": pageId.val(),
							"name": nameInput.val(),
							"email": emailInputBy.val(),
							"emailTo": emailInputTo.val(),
							"text": contentInput.val(),
							"captcha-key": captchaKey.val(),
							"captcha-value": captchaInput.val(),
							"ajax": "true"
						};

						function result(data)
						{
                            $dialog.parent().find(".ui-dialog-buttonpane .ui-button").prop('disabled', false);
                            
							var s = "";
							$j('errors error', data).each(function () { s += $j(this).text() + "\n"; });
							
							if (s == "")
							{
								var errors = $j('error > error', data);
                                var mailErrors = $j('mailError > mailError', data);
                                
								if (errors.length == 0 &amp;&amp; mailErrors.length == 0)
								{
									$dialog.dialog("close");
                                    $j("#sendByMail-btn-<xsl:value-of select="$uniqueId"/>").focus();
                                    alert("<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_SEND_OK" i18n:catalogue="plugin.socialnetworking"/>");
								}
								else if (errors.length > 0)
								{
                                    var m = '';
                                    $j('error > error', data).each(function () { 
                                        m += "\n*" + $j(this).text();
                                    });
									alert("<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_ERROR_DESCRIPTION"  i18n:catalogue="plugin.socialnetworking"/>" + m);
                                    if (sendByMail_captchaRequired_<xsl:value-of select="$uniqueId"/>)
                                    {
                                       refresh_sendByMail_<xsl:value-of select="$uniqueId"/>();
                                    }
								}
                                else if (mailErrors.length > 0)
                                {
                                    var m = '';
                                    $j('mailError > mailError', data).each(function () { 
                                        m += "\n" + $j(this).text();
                                    });
                                    
                                    alert("<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_MESSAGING_ERROR_DESCRIPTION"  i18n:catalogue="plugin.socialnetworking"/>" + m);
                                    if (sendByMail_captchaRequired_<xsl:value-of select="$uniqueId"/>)
                                    {
                                       refresh_sendByMail_<xsl:value-of select="$uniqueId"/>();
                                    }
                                }
							}
							else
							{
                                // Could really append ??
								alert(s);
								if (sendByMail_captchaRequired_<xsl:value-of select="$uniqueId"/>)
                                {
                                   refresh_sendByMail_<xsl:value-of select="$uniqueId"/>();
                                }
							}
						}
                        
                        
                        function handleError(jqXHR, textStatus, errorThrown)
                        {
                            $dialog.parent().find(".ui-dialog-buttonpane .ui-button").prop('disabled', false);
                            alert("<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_GLOBAL_ERROR_DESCRIPTION" i18n:catalogue="plugin.socialnetworking" />");
                        }
						
                        // Disable buttons
                        $dialog.parent().find(".ui-dialog-buttonpane .ui-button").prop('disabled', true);
                        
                        $j.ajax({
                            url: "<xsl:value-of select="$sendByMail-url"/>",
                            data: data,
                            type: 'post',
                            success: result,
                            error: handleError
                        });
					}

					return false;
				}
			</script>
	</xsl:template>	
    
    <xsl:template name="sendByMail-form-hint">
        <p class="hint"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_MANDATORY_HINT" i18n:catalogue="plugin.socialnetworking"/></p>
    </xsl:template>
    
    <xsl:template name="sendByMail-form-field-name">
		<div class="field">
			<div class="label">
				<label for="sendByMail-{$uniqueId}-name">
					<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_NAME" i18n:catalogue="plugin.socialnetworking"/>
					<xsl:call-template name="sendByMail-form-mandatorymarker"/>
				</label>
			</div>
			<div class="input">
				<input type="text" name="name" id="sendByMail-{$uniqueId}-name" aria-required="true"/>
			</div>
			<div class="field-end"></div>
            
            <script type="text/javascript">
                getAmetysUser(function(user) {
                    if (user &amp;&amp; user.fill)
                    {
                        user.fill("sendByMail-<xsl:value-of select="$uniqueId"/>-name", "fullname");
                    }
                });
            </script>  
		</div>
	</xsl:template>
    
   	<xsl:template name="sendByMail-form-field-content">
		<div class="field">
			<div class="label">
				<label for="sendByMail-{$uniqueId}-text">
					<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_CONTENT" i18n:catalogue="plugin.socialnetworking"/>
				</label> 
			</div>
			<div class="input">
				<textarea name="text" id="sendByMail-{$uniqueId}-text" cols="20" rows="3"></textarea>
			</div>
			<div class="field-end"></div>
		</div>
	</xsl:template>
    
    <xsl:template name="sendByMail-form-field-captcha">
		<div class="field">
            <xsl:if test="captcha:requiresUserInteraction()">
    			<div class="label">
    				<label for="sendByMail-{$uniqueId}-captcha">
    					<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_CAPTCHA" i18n:catalogue="plugin.socialnetworking"/>
    					<xsl:call-template name="sendByMail-form-mandatorymarker"/>
    				</label>
    			</div>
            </xsl:if>
			<div class="input captcha-{$captchaType}">
				<xsl:call-template name="captcha">
					<xsl:with-param name="key-name">captcha-key</xsl:with-param>
					<xsl:with-param name="key-id">sendByMail-<xsl:value-of select="$uniqueId"/>-captcha-key</xsl:with-param>

					<xsl:with-param name="value-name">captcha-value</xsl:with-param>
					<xsl:with-param name="value-id">sendByMail-<xsl:value-of select="$uniqueId"/>-captcha</xsl:with-param>
					<xsl:with-param name="value-style"></xsl:with-param>
					<xsl:with-param name="value-class"/>

					<xsl:with-param name="image-style"></xsl:with-param>
					<xsl:with-param name="image-class"/>
					
					<xsl:with-param name="js-funcname-torefresh">refresh_sendByMail_<xsl:value-of select="$uniqueId"/></xsl:with-param>
				</xsl:call-template> 
			</div>
			<div class="field-end"></div>
		</div>
	</xsl:template>	
    
    <xsl:template name="sendByMail-form-field-mail-by">
		<div class="field">
			<div class="label">
				<label for="sendByMail-{$uniqueId}-email-by">
					<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_MAILBY" i18n:catalogue="plugin.socialnetworking"/>
					<xsl:call-template name="sendByMail-form-mandatorymarker"/>
				</label>
			</div>
			<div class="input">
				<input type="text" name="email" id="sendByMail-{$uniqueId}-email-by" aria-required="true"/>
			</div>
			<div class="field-end"></div>
            <script type="text/javascript">
                getAmetysUser(function(user) {
                    if (user &amp;&amp; user.fill)
                    {
                        user.fill("sendByMail-<xsl:value-of select="$uniqueId"/>-email-by", "email");
                    }
                });
            </script>  
		</div>
	</xsl:template>
	
	 <xsl:template name="sendByMail-form-field-mail-to">
		<div class="field">
			<div class="label">
				<label for="sendByMail-{$uniqueId}-email-to">
					<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_MAILTO" i18n:catalogue="plugin.socialnetworking"/>
					<xsl:call-template name="sendByMail-form-mandatorymarker"/>
				</label>
			</div>
			<div class="input">
				<input type="text" name="emailTo" id="sendByMail-{$uniqueId}-email-to" aria-required="true" aria-describedby="sendByMail-{$uniqueId}-email-to-hint"/>
                <br/><span class="hint" id="sendByMail-{$uniqueId}-email-to-hint"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_SEND_MAIL_TO_INFO" i18n:catalogue="plugin.socialnetworking"/></span>
			</div>
			<div class="field-end"></div>
		</div>
	</xsl:template>
	
    <xsl:template name="sendByMail-form-mandatorymarker">
		<span class="mandatory"> *</span>
	</xsl:template>	
    
</xsl:stylesheet>