<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math" 
                extension-element-prefixes="math">
    
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:param name="username" select="ametys:serviceParameter('usersnames')/text()"/>
    <xsl:param name="max" select="ametys:serviceParameter('max')/text()"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">socialnetworking socialnetworking-tweets</xsl:variable>
    <xsl:variable name="is-empty" select="false()"/>
    <xsl:variable name="common-service-name">service-socialnetworking</xsl:variable>
    
    <xsl:variable name="id" select="concat('show_tweets_', substring-after(math:random(), '.'))"/>
    
    <!-- +
         | HEAD
         + -->    
         
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
           !function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+"://platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");
        </script>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    
    <!-- Defined in the service because of the id  -->
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper" id="{$id}">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <xsl:call-template name="common-service-body-nonempty-content-content"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <a class="twitter-timeline" href="https://twitter.com/{$username}">
            <xsl:if test="normalize-space($max) != ''">
                <xsl:attribute name="data-tweet-limit"><xsl:value-of select="$max"/></xsl:attribute>
            </xsl:if>
            <xsl:call-template name="twitter-timeline-dimensions-attributes"/>
            <xsl:call-template name="twitter-timeline-custom-attributes"/>
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_TWITTER_STREAM"/>
                <i18n:param name="username"><xsl:value-of select="$username"/></i18n:param>
            </i18n:translate>
        </a>
    </xsl:template>
    
    <!--
        Customization of timeline dimensions 
        An embedded timeline automatically adjusts to the width of its parent element with a minimum width of 180 pixels and a maximum width of 520 pixels
         -->
    <xsl:template name="twitter-timeline-dimensions-attributes">
        <!-- <xsl:attribute name="data-width">300</xsl:attribute>-->
        <!-- <xsl:attribute name="data-height">300</xsl:attribute> -->
    </xsl:template>
    
    <!-- 
        Customize widget components
        Available settings are :  transparent, noheader, nofooter, noborders, noscrollbar
         -->
    <xsl:template name="twitter-timeline-custom-attributes">
        <xsl:attribute name="data-chrome">transparent noheader nofooter</xsl:attribute>
    </xsl:template>
    
</xsl:stylesheet>
