<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper" 
			    xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<!-- +
		 Display a button to share page on Facebook.
		 @param text : the button text. Defaults to "Share".
		 @param layout : button | icon | box. Defaults to "button".
		 @param counter : true to display a counter. Defaults to false.
		 + -->
	<xsl:template name="FB_share">
		<xsl:param name="text">Share</xsl:param>
		<xsl:param name="layout">button</xsl:param>
		<xsl:param name="counter">false</xsl:param>
		
		<xsl:param name="rendering-context"/>
		
		<xsl:variable name="type">
			<xsl:choose>
				<xsl:when test="$layout = 'button'">button<xsl:if test="$counter = 'true'">_count</xsl:if></xsl:when>
				<xsl:when test="$layout = 'box'">box_count</xsl:when>
				<xsl:when test="$layout = 'icon'">icon</xsl:when>
			</xsl:choose>
		</xsl:variable>
		
		<script src="http://static.ak.fbcdn.net/connect.php/js/FB.Share" type="text/javascript"></script>
		
		<xsl:choose>
			<xsl:when test="$rendering-context = 'front'">
				<a name="fb_share" type="{$type}" href="http://www.facebook.com/sharer.php"><xsl:value-of select="$text"/></a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="FB_loadCSS"/>
				<div class="FBFake">
					<!-- Display fake icons -->
					<xsl:choose>
						<xsl:when test="$layout = 'icon'">
							<span class="FBConnectButton_Simple"><span class="FBConnectButton_Text_Simple">﻿</span></span>
						</xsl:when>
						<xsl:when test="$layout = 'box'">
							<span class="fb_share_size_Small fb_share_count_wrapper">
								<span class="fb_share_count_nub_top "></span>
								<span class="fb_share_count  fb_share_count_top">
									<span class="fb_share_count_inner">10</span>
								</span>
								<span style="cursor: pointer;" class="FBConnectButton FBConnectButton_Small">
									<span class="FBConnectButton_Text"><xsl:value-of select="$text"/></span>
								</span>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<span class="fb_share_size_Small ">
								<span class="FBConnectButton FBConnectButton_Small">
									<span class="FBConnectButton_Text"><xsl:value-of select="$text"/></span>
								</span>
								<span class="fb_share_count_nub_right fb_share_no_count">
									<xsl:if test="$counter = 'true'"><xsl:attribute name="class">fb_share_count_nub_right</xsl:attribute></xsl:if>
								</span>
								<span class="fb_share_count fb_share_no_count fb_share_count_right">
									<xsl:if test="$counter = 'true'"><xsl:attribute name="class">fb_share_count fb_share_count_right</xsl:attribute></xsl:if>
									<span class="fb_share_count_inner">10</span>
								</span>
							</span>
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- +
		 Display a button I like
		 @param absoluteUrl : the button text. Defaults to "Share".
		 @param layout : standard | button_count | box_count. Defaults to "standard".
		 @param action : like | recommend. Defaults to "like".
		 @param showFaces : true to display the profile pictures below the button. Defaults to true.
		 @param width : the width in pixels. Defaults to 450
		 @param height : the height in pixels. Defaults to 80
		 @param colorsheme : light | drak. Defaults to "light"
		 + -->
	<xsl:template name="FB_like">
		<xsl:param name="absoluteUrl"/>
		<xsl:param name="layout">standard</xsl:param>
		<xsl:param name="action">like</xsl:param>
		
		<xsl:param name="showFaces">true</xsl:param>
		<xsl:param name="width">450</xsl:param>
		<xsl:param name="height">80</xsl:param>
		
		<xsl:param name="font">arial</xsl:param>
		<xsl:param name="colorsheme">light</xsl:param>
		
		<xsl:param name="rendering-context">back</xsl:param>
		
		<xsl:choose>
			<xsl:when test="$rendering-context = 'front'">
				<iframe src="http://www.facebook.com/plugins/like.php?href={$absoluteUrl}&amp;layout={$layout}&amp;show_faces={$showFaces}&amp;width={$width}&amp;action={$action}&amp;font={$font}&amp;colorscheme={$colorsheme}&amp;height={$height}" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:{$width}px; height:{$height}px;" allowTransparency="true"></iframe>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="FB_loadCSS"/>
				<div class="FBFake" style="width:{$width}px; height:{$height}px;">
					<div class="connect_button_slider">
						<div class="connect_button_container">
							<span class="connect_widget_like_button clearfix like_button_no_like">
								<span class="liketext"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_FACEBOOK_ILIKE" i18n:catalogue="plugin.socialnetworking"/></span>
							</span>
							<div class="connect_widget_not_connected_text"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_FACEBOOK_ILIKE_HINT" i18n:catalogue="plugin.socialnetworking"/></div>
						</div>
					</div>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template name="FB_loadCSS">
				<!-- search for back css -->
				<script type="text/javascript">
					if (window.__facebook_css_loaded == null)
					{
						window.__facebook_css_loaded = true;
						
						var l = document.createElement("link");
						l.rel = "stylesheet";
						l.href = "<xsl:value-of select="ametys:pluginResourceURL('socialnetworking', 'css/facebook/facebook.css')"/>";
						l.media = "screen";
						
						document.getElementsByTagName("head")[0].appendChild(l);
					}
				</script>
	</xsl:template>		
	
</xsl:stylesheet>