<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
	xmlns:math="http://exslt.org/math" 
	exclude-result-prefixes="math">
	
    <xsl:param name="header" select="ametys:serviceParameter('header')/text()"/>
    <xsl:param name="usersnames" select="ametys:serviceParameter('usersnames')/text()"/>
    <xsl:param name="max" select="ametys:serviceParameter('max')/text()"/>
    <xsl:param name="displayicon" select="ametys:serviceParameter('displayicon')/text()"/>
	
	<xsl:template match="/">
		<xsl:variable name="id" select="concat('show_tweets_', substring-after(math:random(), '.'))"/>
	
		<html>
			<head>
				<script type="text/javascript" src="{ametys:pluginResourceURL('socialnetworking', 'js/twitter/jquery.jtweetsanywhere-1.2.1.min.js')}" /> 
				
				<link type="text/css" href="{ametys:pluginResourceURL('socialnetworking', 'css/twitter/jquery.jtweetsanywhere-1.2.1.css')}" rel="stylesheet" />

				<script type="text/javascript">
					function <xsl:value-of select="$id"/>_onready() 
					{
						var accounts = "<xsl:value-of select="$usersnames" />".split(',');
						var finalAccounts = [];
						
						for (var i = 0; i &lt; accounts.length; i++)
						{
							var account = accounts[i];
							if (account != null &amp;&amp; account.replace(/^\s+|\s+$/g, "") != '')
							{
								finalAccounts.push(account.replace(/^\s+|\s+$/g, ""));
							}
						}

				   		$j('div#<xsl:value-of select="$id"/>').jTweetsAnywhere(
				   			{
						        username: finalAccounts.length &gt; 1 ? finalAccounts : finalAccounts[0],
						        count: <xsl:value-of select="$max" />,
						        showTweetFeed: {
								        showSource: true, // show info about the source of the tweet
								        showTimestamp: true, // to display a tweet's timestamp
								        expandHovercards: true, // show Hovercards in expanded mode
								        showProfileImages : <xsl:value-of select="$displayicon" /> // display a profile image in tweets
								},
								includeRetweets: true,
								showConnectButton: true,
							    showLoginInfo: true,
							    tweetSourceDecorator: function(tweet, options)
								{
									// if tweet is a native retweet, use the retweet's source
									var tw = tweet.retweeted_status || tweet;
							
									var source = tw.source.replace(/\&amp;lt\;/gi,'&lt;').replace(/\&amp;gt\;/gi,'>').replace(/\&amp;quot\;/gi,'"');
									var html =
										'&lt;span class="jta-tweet-source">' +
										' via ' +
										'&lt;span class="jta-tweet-source-link">' +
										source +
										'&lt;/span>' +
										'&lt;/span> ' +
									    '&lt;a class="jta-tweet-retweet" target="_blank" href="http://twitter.com/home?status=' + 'RT+@' + tweet.from_user + ':+' + encodeURIComponent(tweet.text) + '">'
									    + '<i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_TWITTER_RETWEET"/>'
									    + '&lt;/a>';
							
									return html;
								}
							}					        
					    );
					}
					$j(document).ready(<xsl:value-of select="$id"/>_onready);
				</script>
			</head>
			<body>
				<div id="{$id}" class="show-tweets">
					<xsl:if test="$header != ''"><h1><xsl:value-of select="$header"/></h1></xsl:if>
					<noscript>
						<p><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_TWITTER_NOSCRIPT_BEGIN"/></p>
						<ul>
							<xsl:call-template name="split-usernames">
								<xsl:with-param name="usersnames" select="$usersnames"/>
							</xsl:call-template>
						</ul>
						<p><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_TWITTER_NOSCRIPT_END"/></p>
					</noscript>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="split-usernames">
		<xsl:param name="usersnames"/>
		
		<xsl:variable name="username" select="translate(substring-before($usersnames, ','), ' ', '')"/>
		<xsl:choose>
			<xsl:when test="$username = ''">
				<xsl:call-template name="show-tweet">
					<xsl:with-param name="username" select="translate($usersnames, ' ', '')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="show-tweet">
					<xsl:with-param name="username" select="$username"/>
				</xsl:call-template>
				
				<xsl:call-template name="split-usernames">
					<xsl:with-param name="usersnames" select="substring-after($usersnames, ',')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="show-tweet">
		<xsl:param name="username"/>
		
		<li><a href="http://twitter.com/{$username}"><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_TWITTER_NOSCRIPT_USER_BEGIN"/><xsl:value-of select="$username"/><i18n:text i18n:key="PLUGINS_SOCIAL_NETWORKING_TWITTER_NOSCRIPT_USER_END"/></a></li>
	</xsl:template>
</xsl:stylesheet>
