/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.dao;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.Binary;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.survey.repository.AbstractSurveyElement;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public abstract class AbstractDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected UploadManager _uploadManager;
    protected JSONUtils _jsonUtils;
    protected org.apache.avalon.framework.context.Context _context;
    protected Context _cocoonContext;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)serviceManager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._uploadManager = (UploadManager)serviceManager.lookup(UploadManager.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public ModifiableTraversableAmetysObject getSurveyRootNode(String siteName, String lang) throws RepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(siteName).getRootPlugins();
        ModifiableTraversableAmetysObject surveyNode = null;
        surveyNode = !pluginsNode.hasChild("survey") ? (ModifiableTraversableAmetysObject)((ModifiableTraversableAmetysObject)pluginsNode.createChild("survey", "ametys:unstructured")).createChild("ametys:surveys", "ametys:unstructured") : (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys");
        if (!surveyNode.hasChild(lang)) {
            surveyNode.createChild(lang, "ametys:unstructured");
            ((JCRAmetysObject)pluginsNode).getNode().getSession().save();
        }
        return (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys/" + lang);
    }

    protected UserIdentity _getCurrentUser() {
        return this._currentUserProvider.getUser();
    }

    protected void updateReferencesAfterCopy(Survey originalSurvey, Survey createdSurvey) {
        for (SurveyPage cPage : createdSurvey.getPages()) {
            this.updateReferencesAfterCopy(originalSurvey, createdSurvey, cPage);
        }
    }

    protected void updateReferencesAfterCopy(Survey originalSurvey, Survey createdSurvey, SurveyPage createdPage) {
        SurveyRule rule;
        String pageId;
        if (createdPage.hasRule() && (pageId = (rule = createdPage.getRule()).getPage()) != null) {
            try {
                AmetysObject originalPage = this._resolver.resolveById(pageId);
                AmetysObject symmetricPage = createdSurvey.getChild(originalPage.getName());
                createdPage.setRule(rule.getType(), symmetricPage.getId());
            }
            catch (UnknownAmetysObjectException e) {
                new SLF4JLoggerAdapter(LoggerFactory.getLogger(((Object)((Object)this)).getClass())).warn("Symmetric page has not found during copy. The rule is deleted.");
                createdPage.deleteRule();
            }
        }
        for (SurveyQuestion cQuestion : createdPage.getQuestions()) {
            this.updateReferencesAfterCopy(originalSurvey, createdSurvey, cQuestion);
        }
    }

    protected void updateReferencesAfterCopy(Survey originalSurvey, Survey createdSurvey, SurveyQuestion createdQuestion) {
        for (SurveyRule cRule : createdQuestion.getRules()) {
            String pageId = cRule.getPage();
            if (pageId == null) continue;
            String option = cRule.getOption();
            try {
                AmetysObject originalPage = this._resolver.resolveById(pageId);
                AmetysObject symmetricPage = createdSurvey.getChild(originalPage.getName());
                SurveyRule.RuleType type = cRule.getType();
                createdQuestion.deleteRule(option);
                createdQuestion.addRules(option, type, symmetricPage.getId());
            }
            catch (UnknownAmetysObjectException e) {
                new SLF4JLoggerAdapter(LoggerFactory.getLogger(((Object)((Object)this)).getClass())).warn("Symmetric page has not found during copy. The rule is deleted.");
                createdQuestion.deleteRule(option);
            }
        }
    }

    protected void setPicture(AbstractSurveyElement elmt, String valueAsStr) {
        if (StringUtils.isNotEmpty((CharSequence)valueAsStr)) {
            Map picture = this._jsonUtils.convertJsonToMap(valueAsStr);
            if (!picture.isEmpty()) {
                String pictureType = (String)picture.get("type");
                String value = (String)picture.get("id");
                if (pictureType.equals("explorer") && !"untouched".equals(value)) {
                    elmt.setResourcePicture(value);
                } else if (!"untouched".equals(value)) {
                    UserIdentity user = this._currentUserProvider.getUser();
                    Upload upload = this._uploadManager.getUpload(user, value);
                    String filename = upload.getFilename();
                    String mimeType = upload.getMimeType() != null ? upload.getMimeType() : this._cocoonContext.getMimeType(filename);
                    String finalMimeType = mimeType != null ? mimeType : "application/unknown";
                    elmt.setExternalPicture(finalMimeType, filename, upload.getInputStream());
                }
            } else {
                elmt.setNoPicture();
            }
        } else {
            elmt.setNoPicture();
        }
    }

    protected Map<String, Object> getPictureInfo(AbstractSurveyElement elmt) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("pictureAlternative", StringUtils.defaultString((String)elmt.getPictureAlternative()));
        HashMap<String, Object> pictureInfos = new HashMap<String, Object>();
        String pictureType = elmt.getPictureType();
        if (StringUtils.isNotBlank((CharSequence)pictureType)) {
            if (pictureType.equals("resource")) {
                String resourceId = elmt.getResourcePictureId();
                pictureInfos.put("id", resourceId);
                try {
                    Resource resource = (Resource)this._resolver.resolveById(resourceId);
                    pictureInfos.put("filename", resource.getName());
                    pictureInfos.put("size", resource.getLength());
                    pictureInfos.put("type", "explorer");
                    pictureInfos.put("lastModified", resource.getLastModified());
                    String contextPath = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context).getContextPath();
                    String viewUrl = contextPath + "/plugins/explorer/resource?id=" + resource.getId();
                    String downloadUrl = viewUrl + "&download=true";
                    pictureInfos.put("viewUrl", viewUrl);
                    pictureInfos.put("downloadUrl", downloadUrl);
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().error("The resource of id'" + resourceId + "' does not exist anymore. The picture for element of id '" + elmt.getId() + "' will be ignored.", (Throwable)e);
                    properties.put("pictureNotFound", true);
                }
            } else if (pictureType.equals("external")) {
                Binary picMeta = elmt.getExternalPicture();
                pictureInfos.put("path", "picture");
                pictureInfos.put("filename", picMeta.getFilename());
                pictureInfos.put("size", picMeta.getLength());
                pictureInfos.put("lastModified", picMeta.getLastModificationDate());
                pictureInfos.put("type", "metadata");
                String contextPath = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._context).getContextPath();
                String viewUrl = contextPath + "/plugins/cms/binary/picture?objectId=" + elmt.getId();
                String downloadUrl = viewUrl + "&download=true";
                pictureInfos.put("viewUrl", viewUrl);
                pictureInfos.put("downloadUrl", downloadUrl);
            }
        }
        properties.put("picture", pictureInfos);
        return properties;
    }
}

