/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.survey.dao.AbstractDAO;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.apache.commons.lang3.StringUtils;

public class QuestionDAO
extends AbstractDAO {
    public static final String ROLE = QuestionDAO.class.getName();

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getQuestion(String id) {
        SurveyQuestion question = (SurveyQuestion)this._resolver.resolveById(id);
        return this.getQuestion(question);
    }

    public Map<String, Object> getQuestion(SurveyQuestion question) {
        Map<String, String> options;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", question.getId());
        properties.put("type", (Object)question.getType());
        properties.put("label", question.getLabel());
        properties.put("title", question.getTitle());
        properties.put("regexp", question.getRegExpType());
        properties.put("mandatory", String.valueOf(question.isMandatory()));
        properties.put("validated", String.valueOf(question.getSurvey().isValidated()));
        Map<String, String> columns = question.getColumns();
        if (columns.size() > 0) {
            properties.put("columns", columns);
        }
        if ((options = question.getOptions()).size() > 0) {
            properties.put("otherOption", String.valueOf(question.hasOtherOption()));
            properties.put("options", options);
        }
        properties.putAll(this.getPictureInfo(question));
        return properties;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> createQuestion(Map<String, Object> values) {
        HashMap<String, String> result = new HashMap<String, String>();
        String pageId = StringUtils.defaultString((String)((String)values.get("pageId")));
        SurveyPage page = (SurveyPage)this._resolver.resolveById(pageId);
        String label = StringUtils.defaultString((String)((String)values.get("label")));
        String originalName = NameHelper.filterName((String)label);
        String uniqueName = page.getSurvey().findUniqueQuestionName(originalName);
        SurveyQuestion question = (SurveyQuestion)page.createChild(uniqueName, "ametys:survey-question");
        this._setValues(question, values);
        page.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", page.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", question.getId());
        result.put("pageId", page.getId());
        result.put("surveyId", question.getSurvey().getId());
        result.put("type", question.getType().toString());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> editQuestion(Map<String, Object> values) {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = StringUtils.defaultString((String)((String)values.get("id")));
        SurveyQuestion question = (SurveyQuestion)this._resolver.resolveById(id);
        this._setValues(question, values);
        question.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", question.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", question.getId());
        result.put("pageId", question.getParent().getId());
        result.put("surveyId", question.getSurvey().getId());
        result.put("type", question.getType().toString());
        return result;
    }

    private void _setValues(SurveyQuestion question, Map<String, Object> values) {
        String columns;
        question.setTitle(StringUtils.defaultString((String)((String)values.get("title"))));
        question.setLabel(StringUtils.defaultString((String)((String)values.get("label"))));
        question.setMandatory("true".equals(values.get("mandatory")));
        String qType = StringUtils.defaultString((String)((String)values.get("type")));
        question.setType(SurveyQuestion.QuestionType.valueOf(qType));
        question.setRegExpType(StringUtils.defaultString((String)((String)values.get("regexp"))));
        question.setPictureAlternative(StringUtils.defaultString((String)((String)values.get("picture-alternative"))));
        this.setPicture(question, StringUtils.defaultString((String)((String)values.get("picture"))));
        boolean hasOtherOption = "true".equals(values.get("otherOption"));
        String options = (String)values.get("options");
        if (StringUtils.isNotEmpty((CharSequence)options)) {
            Map rawOpts = this._jsonUtils.convertJsonToMap(options);
            LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
            for (String optLabel : rawOpts.keySet()) {
                String optVal = (String)rawOpts.get(optLabel);
                if (StringUtils.isEmpty((CharSequence)optVal)) {
                    optVal = NameHelper.filterName((String)("opt-" + optLabel));
                }
                opts.put(optVal, optLabel);
            }
            question.setOptions(opts);
            question.setOtherOption(hasOtherOption);
        }
        if (StringUtils.isNotEmpty((CharSequence)(columns = (String)values.get("columns")))) {
            Map rawCols = this._jsonUtils.convertJsonToMap(columns);
            LinkedHashMap<String, String> cols = new LinkedHashMap<String, String>();
            for (String colLabel : rawCols.keySet()) {
                String colVal = (String)rawCols.get(colLabel);
                if (StringUtils.isEmpty((CharSequence)colVal)) {
                    colVal = NameHelper.filterName((String)("opt-" + colLabel));
                }
                cols.put(colVal, colLabel);
            }
            question.setColumns(cols);
        }
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> copyQuestion(String pageId, String questionId) {
        HashMap<String, String> result = new HashMap<String, String>();
        SurveyQuestion originalQuestion = (SurveyQuestion)this._resolver.resolveById(questionId);
        SurveyPage parentPage = (SurveyPage)this._resolver.resolveById(pageId);
        Survey originalSurvey = originalQuestion.getSurvey();
        Survey parentSurvey = parentPage.getSurvey();
        String name = parentSurvey.findUniqueQuestionName(originalQuestion.getName());
        SurveyQuestion cQuestion = originalQuestion.copyTo((ModifiableTraversableAmetysObject)parentPage, name);
        if (!originalSurvey.getId().equals(parentSurvey.getId())) {
            this.updateReferencesAfterCopy(originalSurvey, parentSurvey, cQuestion);
        }
        parentPage.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", parentSurvey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", cQuestion.getId());
        result.put("pageId", parentPage.getId());
        result.put("surveyId", parentSurvey.getId());
        result.put("type", cQuestion.getType().toString());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> deleteQuestion(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        SurveyQuestion question = (SurveyQuestion)this._resolver.resolveById(id);
        String type = question.getType().toString();
        SurveyPage page = (SurveyPage)question.getParent();
        question.remove();
        page.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", page.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", id);
        result.put("pageId", page.getId());
        result.put("surveyId", page.getSurvey().getId());
        result.put("type", type);
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> addRule(String id, String option, String rule, String page) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SurveyQuestion question = (SurveyQuestion)this._resolver.resolveById(id);
        if (question.hasRule(option)) {
            result.put("error", "already-exists");
            return result;
        }
        question.addRules(option, SurveyRule.RuleType.valueOf(rule), page);
        question.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", question.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> deleteRule(String id, String option) {
        SurveyQuestion question = (SurveyQuestion)this._resolver.resolveById(id);
        question.deleteRule(option);
        question.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", question.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        return new HashMap<String, Object>();
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getRules(String id, int number) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SurveyQuestion question = (SurveyQuestion)this._resolver.resolveById(id);
        Map<String, String> options = question.getOptions();
        result.put("id", question.getId());
        result.put("number", String.valueOf(number));
        result.put("title", question.getTitle());
        ArrayList rules = new ArrayList();
        for (SurveyRule rule : question.getRules()) {
            HashMap<String, String> resultRule = new HashMap<String, String>();
            String option = rule.getOption();
            resultRule.put("option", option);
            resultRule.put("optionLabel", options.get(option));
            resultRule.put("type", rule.getType().name());
            String page = rule.getPage();
            if (page != null) {
                try {
                    SurveyPage pageAO = (SurveyPage)this._resolver.resolveById(page);
                    resultRule.put("page", page);
                    resultRule.put("pageName", pageAO.getLabel());
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                    // empty catch block
                }
            }
            rules.add(resultRule);
        }
        result.put("rules", rules);
        return result;
    }
}

