/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.repository;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.ametys.cms.indexing.solr.SolrAclCacheUninfluentialObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ChainedAmetysObjectIterable;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.survey.SurveyDateUtils;
import org.ametys.plugins.survey.repository.AbstractSurveyElement;
import org.ametys.plugins.survey.repository.SurveyFactory;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.web.repository.SiteAwareAmetysObject;
import org.ametys.web.repository.site.Site;

@SolrAclCacheUninfluentialObject
public class Survey
extends AbstractSurveyElement<SurveyFactory>
implements SiteAwareAmetysObject {
    private static final String __PROPERTY_TITLE = "ametys-internal:title";
    private static final String __PROPERTY_LABEL = "ametys-internal:label";
    private static final String __PROPERTY_DESC = "ametys-internal:description";
    private static final String __PROPERTY_ENDING_MSG = "ametys-internal:endingMessage";
    private static final String __PROPERTY_VALIDATED = "ametys-internal:validated";
    private static final String __PROPERTY_VALIDATION_DATE = "ametys-internal:validationDate";
    private static final String __PROPERTY_START_DATE = "ametys-internal:startDate";
    private static final String __PROPERTY_END_DATE = "ametys-internal:endDate";
    private static final String __PROPERTY_REDIRECTION = "ametys-internal:redirection";
    private static final String __PROPERTY_REINIT_DATE = "ametys-internal:reinitDate";

    public Survey(Node node, String parentPath, SurveyFactory factory) {
        super(node, parentPath, factory);
    }

    public String getTitle() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_TITLE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get title property", (Throwable)e);
        }
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set title property", (Throwable)e);
        }
    }

    public String getLabel() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_LABEL).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get label property", (Throwable)e);
        }
    }

    public void setLabel(String label) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_LABEL, label);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set label property", (Throwable)e);
        }
    }

    public String getDescription() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_DESC).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get description property", (Throwable)e);
        }
    }

    public void setDescription(String description) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_DESC, description);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set description property", (Throwable)e);
        }
    }

    public String getEndingMessage() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_ENDING_MSG).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get ending message property", (Throwable)e);
        }
    }

    public void setEndingMessage(String message) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_ENDING_MSG, message);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set ending message property", (Throwable)e);
        }
    }

    public boolean isValidated() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_VALIDATED).getBoolean();
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get validated property", (Throwable)e);
        }
    }

    public void setValidated(boolean validated) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_VALIDATED, validated);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to validate survey", (Throwable)e);
        }
    }

    public void setValidationDate(Date date) throws AmetysRepositoryException {
        try {
            if (date != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                this.getNode().setProperty(__PROPERTY_VALIDATION_DATE, (Calendar)calendar);
            } else if (this.getNode().hasProperty(__PROPERTY_VALIDATION_DATE)) {
                this.getNode().getProperty(__PROPERTY_VALIDATION_DATE).remove();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set date of validation", (Throwable)e);
        }
    }

    public Date getValidationDate() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_VALIDATION_DATE).getDate().getTime();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get validation date property", (Throwable)e);
        }
    }

    public void setStartDate(Date date) throws AmetysRepositoryException {
        try {
            if (date != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                this.getNode().setProperty(__PROPERTY_START_DATE, (Calendar)calendar);
            } else if (this.getNode().hasProperty(__PROPERTY_START_DATE)) {
                this.getNode().getProperty(__PROPERTY_START_DATE).remove();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set start date", (Throwable)e);
        }
    }

    public Date getStartDate() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_START_DATE).getDate().getTime();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get start date property", (Throwable)e);
        }
    }

    public void setEndDate(Date date) throws AmetysRepositoryException {
        try {
            if (date != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                this.getNode().setProperty(__PROPERTY_END_DATE, (Calendar)calendar);
            } else if (this.getNode().hasProperty(__PROPERTY_END_DATE)) {
                this.getNode().getProperty(__PROPERTY_END_DATE).remove();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set end date", (Throwable)e);
        }
    }

    public Date getEndDate() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_END_DATE).getDate().getTime();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get end date property", (Throwable)e);
        }
    }

    public String getRedirection() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_REDIRECTION).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get redirection property", (Throwable)e);
        }
    }

    public void setRedirection(String pageId) throws AmetysRepositoryException {
        try {
            if (pageId == null) {
                if (this.getNode().hasProperty(__PROPERTY_REDIRECTION)) {
                    this.getNode().getProperty(__PROPERTY_REDIRECTION).remove();
                }
            } else {
                this.getNode().setProperty(__PROPERTY_REDIRECTION, pageId);
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set redirection property", (Throwable)e);
        }
    }

    public void reinit() throws AmetysRepositoryException {
        try {
            ZonedDateTime zdt = ZonedDateTime.now(ZoneId.of("UTC"));
            this.getNode().setProperty(__PROPERTY_REINIT_DATE, SurveyDateUtils.asCalendar(zdt));
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set re-initialization date", (Throwable)e);
        }
    }

    public ZonedDateTime getReinitDate() throws AmetysRepositoryException {
        try {
            Calendar calendar = this.getNode().getProperty(__PROPERTY_REINIT_DATE).getDate();
            return SurveyDateUtils.asZonedDateTime(calendar);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get re-initialization date property", (Throwable)e);
        }
    }

    public List<SurveyPage> getPages() throws AmetysRepositoryException {
        return this.getChildren().stream().filter(child -> child instanceof SurveyPage).map(child -> (SurveyPage)((Object)child)).collect(Collectors.toList());
    }

    public SurveyQuestion getQuestion(String name) throws AmetysRepositoryException {
        for (SurveyPage page : this.getPages()) {
            if (!page.hasChild(name)) continue;
            return page.getQuestion(name);
        }
        return null;
    }

    public AmetysObjectIterable<SurveyQuestion> getQuestions() throws AmetysRepositoryException {
        ArrayList<AmetysObjectIterable<SurveyQuestion>> questions = new ArrayList<AmetysObjectIterable<SurveyQuestion>>();
        for (SurveyPage page : this.getPages()) {
            questions.add(page.getQuestions());
        }
        return new ChainedAmetysObjectIterable(questions);
    }

    public Site getSite() throws AmetysRepositoryException {
        return (Site)this.getParent().getParent().getParent().getParent().getParent();
    }

    public String getSiteName() throws AmetysRepositoryException {
        return this.getSite().getName();
    }

    public String getLanguage() {
        return this.getParent().getName();
    }

    public String findUniqueQuestionName(String originalName) {
        Object name = originalName;
        int index = 2;
        while (this._hasQuestionName((String)name)) {
            name = originalName + "-" + index++;
        }
        return name;
    }

    private boolean _hasQuestionName(String name) {
        for (SurveyPage page : this.getPages()) {
            if (!page.hasQuestion(name)) continue;
            return true;
        }
        return false;
    }

    public Survey copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        String endingMessage;
        Survey survey = (Survey)parent.createChild(name, "ametys:survey");
        survey.setTitle(this.getTitle());
        survey.setLabel(this.getLabel());
        String description = this.getDescription();
        if (description != null) {
            survey.setDescription(description);
        }
        if ((endingMessage = this.getEndingMessage()) != null) {
            survey.setEndingMessage(endingMessage);
        }
        this.copyPictureTo(survey);
        survey.setValidated(false);
        for (SurveyPage surveyPage : this.getPages()) {
            surveyPage.copyTo((ModifiableTraversableAmetysObject)survey, surveyPage.getName());
        }
        return survey;
    }

    public Survey copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }
}

