/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.repository;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.survey.repository.AbstractSurveyElement;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPageFactory;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;

public class SurveyPage
extends AbstractSurveyElement<SurveyPageFactory> {
    private static final String __PROPERTY_LABEL = "ametys-internal:label";
    private static final String __PROPERTY_TITLE = "ametys-internal:title";
    private static final String __PROPERTY_DESC = "ametys-internal:description";
    private static final String __PROPERTY_RULE = "ametys-internal:rule";
    private static final String __PROPERTY_RULE_TYPE = "ametys-internal:rule";
    private static final String __PROPERTY_RULE_PAGE = "ametys-internal:page";

    public SurveyPage(Node node, String parentPath, SurveyPageFactory factory) {
        super(node, parentPath, factory);
    }

    public String getTitle() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_TITLE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get title property", (Throwable)e);
        }
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set title property", (Throwable)e);
        }
    }

    public String getLabel() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_LABEL).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get label property", (Throwable)e);
        }
    }

    public void setLabel(String name) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_LABEL, name);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set label property", (Throwable)e);
        }
    }

    public String getDescription() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_DESC).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get description property", (Throwable)e);
        }
    }

    public void setDescription(String description) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_DESC, description);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set description property", (Throwable)e);
        }
    }

    public void setRule(SurveyRule.RuleType ruleType, String page) throws AmetysRepositoryException {
        try {
            if (!this.getNode().hasNode("ametys-internal:rule")) {
                this.getNode().addNode("ametys-internal:rule", "ametys:survey-rule");
            }
            Node ruleNode = this.getNode().getNode("ametys-internal:rule");
            ruleNode.setProperty("ametys-internal:rule", ruleType.name());
            if (ruleType == SurveyRule.RuleType.JUMP || ruleType == SurveyRule.RuleType.SKIP) {
                ruleNode.setProperty(__PROPERTY_RULE_PAGE, page);
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add rule", (Throwable)e);
        }
    }

    public void deleteRule() throws AmetysRepositoryException {
        try {
            if (this.getNode().hasNode("ametys-internal:rule")) {
                this.getNode().getNode("ametys-internal:rule").remove();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to delete rule", (Throwable)e);
        }
    }

    public boolean hasRule() throws AmetysRepositoryException {
        try {
            return this.getNode().hasNode("ametys-internal:rule");
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get rule property", (Throwable)e);
        }
    }

    public SurveyRule getRule() throws AmetysRepositoryException {
        try {
            if (this.getNode().hasNode("ametys-internal:rule")) {
                Node node = this.getNode().getNode("ametys-internal:rule");
                SurveyRule.RuleType type = SurveyRule.RuleType.valueOf(node.getProperty("ametys-internal:rule").getString());
                String page = null;
                if (node.hasProperty(__PROPERTY_RULE_PAGE)) {
                    page = node.getProperty(__PROPERTY_RULE_PAGE).getString();
                }
                return new SurveyRule(type, page);
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get rule property", (Throwable)e);
        }
    }

    public Survey getSurvey() throws AmetysRepositoryException {
        return (Survey)this.getParent();
    }

    public boolean hasQuestion(String name) throws AmetysRepositoryException {
        return this.hasChild(name);
    }

    public SurveyQuestion getQuestion(String name) throws AmetysRepositoryException {
        return (SurveyQuestion)this.getChild(name);
    }

    public AmetysObjectIterable<SurveyQuestion> getQuestions() throws AmetysRepositoryException {
        return this.getChildren();
    }

    public SurveyPage copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        SurveyPage page = (SurveyPage)parent.createChild(name, "ametys:survey-page");
        page.setTitle(this.getTitle());
        page.setLabel(this.getLabel());
        String description = this.getDescription();
        if (description != null) {
            page.setDescription(description);
        }
        this.copyPictureTo(page);
        SurveyRule rule = this.getRule();
        if (rule != null) {
            page.setRule(this.getRule().getType(), this.getRule().getPage());
        }
        Survey parentSurvey = page.getSurvey();
        for (SurveyQuestion question : this.getQuestions()) {
            question.copyTo((ModifiableTraversableAmetysObject)page, parentSurvey.findUniqueQuestionName(question.getName()));
        }
        return page;
    }

    public SurveyPage copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }
}

