<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="contextPath" />
    <xsl:param name="cms-context" />
    <xsl:param name="plugin" />
    <xsl:param name="site" />
    <xsl:param name="lang" />
    
    <xsl:template match="/">
        <html>
            <head>
            </head>
            <body id="default">
                <div class="survey-errors">
                    <xsl:choose>
                        <xsl:when test="survey-errors/survey-access">
                            <p class="message">
                                <xsl:value-of select="survey-errors/survey-access/error"/>
                            </p>
                        </xsl:when>
                        <xsl:otherwise>
                            <p class="message"><i18n:text i18n:key="PLUGINS_SURVEY_RENDER_ERRORS"/></p>
                            <xsl:if test="survey-errors/question/error">
                                <ul class="survey-errors">
                                    <xsl:for-each select="survey-errors/question/error">
                                        <li>
                                            <xsl:value-of select="../@title"/>
                                            <xsl:text> : </xsl:text>
                                            <xsl:value-of select="."/>
                                        </li>
                                    </xsl:for-each>
                                </ul>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </body>
        </html>
    </xsl:template>
    
</xsl:stylesheet>
