/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a survey tree. See {@link Ametys.plugins.survey.SurveyTree}
 * @private
 */
 Ext.define('Ametys.plugins.survey.SurveyTree.SurveyNodeEntry', { 
    extend: 'Ext.data.Model',
    
    fields: [
        'id',
        'name',
        {
            name: 'text', mapping: 'label', type: 'string'
        },
        'title',
        'private', // For a survey, indicates if it is a private or public one
        'validated', // For a survey, indicates if it is validated or not
        'questionType', // For a question node, the type of question (FREE_TEXT, MULTILINE_FREE_TEXT, SINGLE_CHOICE, MULTIPLE_CHOICE, SINGLE_MATRIX, MULTIPLE_MATRIX, etc.)
        'mandatory', // For a question, is this a mandatory question
        'type', // The type of node, can only be 'root', 'survey', 'page' or 'question'
        {
            name: 'children', 
            depends: ['hasChildren'], 
            calculate: function (data) 
            {
                if (!data.hasChildren)
                {
                    return [];
                }
                return null;
            }
        },
        { name: 'hasChildren', mapping: 'hasChildren', type: 'boolean'},
        {
            name: 'allowDrag',
            type: 'boolean',
            calculate: function(data)
            {
                return (data.type == 'page' || data.type == 'question');
            }
        },
        {
            name: 'allowDrop',
            type: 'boolean',
            calculate: function(data)
            {
                return (data.type == 'survey' || data.type == 'page');
            }
        },
        {
            name: 'iconCls',
            calculate: function (data)
            {
                if (data.type == 'root')
                {
                    return 'a-tree-glyph ametysicon-list24';
                }
                else if (data.type == 'survey')
                {
                    return 'a-tree-glyph ametysicon-list24' + (data['private'] ? ' decorator-ametysicon-lock81 private' : '') + (data.validated ? ' validated' : '');
                }
                else if (data.type == 'page')
                {
                    return 'a-tree-glyph ametysicon-website38';
                }
                else if (data.type == 'question' && data.questionType == 'FREE_TEXT')
                {
                    return 'a-tree-glyph ametysicon-input';
                }
                else if (data.type == 'question' && data.questionType == 'MULTILINE_FREE_TEXT')
                {
                	return 'a-tree-glyph ametysicon-text-input';
                }
                else if (data.type == 'question' && data.questionType == 'SINGLE_CHOICE')
                {
                    return 'a-tree-glyph ametysicon-radio-on-button';
                }
                else if (data.type == 'question' && data.questionType == 'MULTIPLE_CHOICE')
                {
                    return 'a-tree-glyph ametysicon-check51';
                }
                else if (data.type == 'question' && (data.questionType == 'SINGLE_MATRIX' || data.questionType == 'MULTIPLE_MATRIX'))
                {
                    return 'a-tree-glyph ametysicon-matrix';
                }
                else
                {
                    return 'a-tree-glyph ametysicon-question13';
                }
            }
        },
        {
            name: 'tooltipIconCls',
            calculate: function (data)
            {
                if (data.type == 'root')
                {
                    return 'ametysicon-list24';
                }
                else if (data.type == 'survey')
                {
                    return 'ametysicon-list24' + (data['private'] ? ' decorator-ametysicon-lock81' : '');
                }
                else if (data.type == 'page')
                {
                    return 'ametysicon-website38';
                }
                else if (data.type == 'question' && data.questionType == 'FREE_TEXT')
                {
                    return 'ametysicon-input';
                }
                else if (data.type == 'question' && data.questionType == 'MULTILINE_FREE_TEXT')
                {
                	return 'ametysicon-text-input';
                }
                else if (data.type == 'question' && data.questionType == 'SINGLE_CHOICE')
                {
                    return 'ametysicon-radio-on-button';
                }
                else if (data.type == 'question' && data.questionType == 'MULTIPLE_CHOICE')
                {
                    return 'ametysicon-check51';
                }
                else if (data.type == 'question' && (data.questionType == 'SINGLE_MATRIX' || data.questionType == 'MULTIPLE_MATRIX'))
                {
                    return 'ametysicon-tables1';
                }
                else
                {
                    return 'ametysicon-question13';
                }
            }
        },
        {
            name: 'tooltipIconDecorator',
            calculate: function (data)
            {
                if (data.type == 'survey' && data['private'])
                {
                    return "decorator-ametysicon-lock81";
                }
                return "";
            }
        }
    ]
});