/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.answer;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Action that processes the user submitted data on a survey.
 */
public class SurveyErrorsGenerator extends AbstractGenerator
{

    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        
        Survey survey = (Survey) request.getAttribute("survey");
        SurveyErrors errors = (SurveyErrors) request.getAttribute("survey-errors");
        
        Map<String, List<I18nizableText>> errorMap = errors.getErrors();
        
        contentHandler.startDocument();
        
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", survey.getId());
        atts.addCDATAAttribute("title", survey.getTitle());
        atts.addCDATAAttribute("label", survey.getLabel());
        
        XMLUtils.startElement(contentHandler, "survey-errors", atts);
        
        for (Map.Entry<String, List<I18nizableText>> fieldErrors : errorMap.entrySet())
        {
            String questionName = fieldErrors.getKey();
            List<I18nizableText> messages = fieldErrors.getValue();
            
            if (StringUtils.isEmpty(questionName) || "survey-access".equals(questionName))
            {
                
                XMLUtils.startElement(contentHandler, "survey-access");
                for (I18nizableText message : messages)
                {
                    message.toSAX(contentHandler, "error");
                }
                XMLUtils.endElement(contentHandler, "survey-access");
            }
            else
            {
                SurveyQuestion question = survey.getQuestion(questionName);
                
                atts.clear();
                atts.addCDATAAttribute("id", question.getId());
                atts.addCDATAAttribute("name", questionName);
                atts.addCDATAAttribute("label", question.getLabel());
                atts.addCDATAAttribute("title", question.getTitle());
                atts.addCDATAAttribute("type", question.getType().toString());
                
                XMLUtils.startElement(contentHandler, "question", atts);
                
                for (I18nizableText message : messages)
                {
                    message.toSAX(contentHandler, "error");
                }
                
                XMLUtils.endElement(contentHandler, "question");
            }
        }
        
        XMLUtils.endElement(contentHandler, "survey-errors");
        
        contentHandler.endDocument();
    }

}
