/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.repository;

/**
 * Class representing a survey rule on a page or question.
 */
public class SurveyRule
{
    
    /** Type of a page. */
    public enum RuleType
    {
        /** Jump. */
        JUMP,
        /** Skip. */
        SKIP,
        /** Finish. */
        FINISH
    }
    
    private String _option;
    private RuleType _type;
    private String _page;
    
    /**
     * Constructor
     * @param type the type 
     * @param page the page to jump or skip
     */
    public SurveyRule (RuleType type, String page)
    {
        this(null, type, page);
    }
    
    /**
     * Constructor
     * @param option the selected option
     * @param type the type 
     * @param page the page to jump or skip
     */
    public SurveyRule (String option, RuleType type, String page)
    {
        _option = option;
        _type = type;
        _page = page;
    }
    
    /**
     * Get the selected option
     * @return the selected option
     */
    public String getOption ()
    {
        return _option;
    }
    
    /**
     * Get the type
     * @return the type
     */
    public RuleType getType ()
    {
        return _type;
    }
    
    /**
     * Get the page to jump or skip. Can be null.
     * @return the page to jump or skip
     */
    public String getPage ()
    {
        return _page;
    }

}
