/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.dao.SurveyDAO;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class InvitationsClientSideElement
extends StaticClientSideElement {
    protected AmetysObjectResolver _resolver;
    private SurveyDAO _surveyDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._surveyDAO = (SurveyDAO)((Object)smanager.lookup(SurveyDAO.ROLE));
    }

    @Callable(rights={"Plugins_Survey_Right_LimitAccess"}, context="/cms")
    public Map<String, Object> getStatus(String surveyId) {
        I18nizableText msg;
        I18nizableText ed;
        ArrayList<String> i18nParameters;
        SitemapElement sitemapElement;
        HashMap<String, Object> results = new HashMap<String, Object>();
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        boolean isPrivate = this._surveyDAO.isPrivate(survey);
        boolean isValided = survey.isValidated();
        String siteName = survey.getSiteName();
        String language = survey.getLanguage();
        Page page = null;
        String xpathQuery = "//element(" + siteName + ", ametys:site)/ametys-internal:sitemaps/" + language + "//element(*, ametys:zoneItem)[@ametys-internal:service = 'org.ametys.survey.service.Display' and ametys:service_parameters/@ametys:surveyId = '" + surveyId + "']";
        AmetysObjectIterable zoneItems = this._resolver.query(xpathQuery);
        AmetysObjectIterator it = zoneItems.iterator();
        if (it.hasNext() && (sitemapElement = ((ZoneItem)it.next()).getZone().getSitemapElement()) instanceof Page) {
            page = (Page)sitemapElement;
        }
        if (!isPrivate) {
            i18nParameters = new ArrayList<String>();
            i18nParameters.add(survey.getLabel());
            ed = (I18nizableText)this._script.getParameters().get("no-private-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
            results.put("status", "no-private");
            results.put("description", msg);
        }
        if (!isValided) {
            i18nParameters = new ArrayList();
            i18nParameters.add(survey.getLabel());
            ed = (I18nizableText)this._script.getParameters().get("no-validated-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
            results.put("status", "no-validated");
            results.put("description", msg);
        }
        if (page == null) {
            i18nParameters = new ArrayList();
            i18nParameters.add(survey.getLabel());
            ed = (I18nizableText)this._script.getParameters().get("no-page-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
            results.put("status", "no-page");
            results.put("description", msg);
        }
        if (isPrivate && isValided && page != null) {
            i18nParameters = new ArrayList();
            i18nParameters.add(survey.getLabel());
            ed = (I18nizableText)this._script.getParameters().get("all-right-description");
            msg = new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
            results.put("page-id", new I18nizableText(page.getId()));
            results.put("status", "all-right");
            results.put("description", msg);
        }
        return results;
    }
}

