/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.clientsideelement;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.I18nUtils;

public class ScheduledSurveyClientSideElement
extends StaticClientSideElement
implements Contextualizable {
    private Context _context;
    private AmetysObjectResolver _resolver;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getScheduledDates(String surveyId) {
        Date endDate;
        HashMap<String, Object> dates = new HashMap<String, Object>();
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        Date startDate = survey.getStartDate();
        if (startDate != null) {
            dates.put("startDate", DateUtils.dateToString((Date)startDate));
        }
        if ((endDate = survey.getEndDate()) != null) {
            dates.put("endDate", DateUtils.dateToString((Date)endDate));
        }
        return dates;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public boolean setScheduledDate(List<String> surveyIds, String startDateAsStr, String endDateAsStr) {
        Date startDate = startDateAsStr != null ? DateUtils.parse((String)startDateAsStr) : null;
        Date endDate = endDateAsStr != null ? DateUtils.parse((String)endDateAsStr) : null;
        for (String id : surveyIds) {
            Survey survey = (Survey)this._resolver.resolveById(id);
            survey.setStartDate(startDate);
            survey.setEndDate(endDate);
            survey.saveChanges();
        }
        return true;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getStatus(List<String> surveysId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("allright-surveys", new ArrayList());
        results.put("scheduled-surveys", new ArrayList());
        results.put("scheduled-valid-surveys", new ArrayList());
        results.put("scheduled-forthcoming-surveys", new ArrayList());
        results.put("scheduled-outofdate-surveys", new ArrayList());
        GregorianCalendar now = new GregorianCalendar();
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        for (String surveyId : surveysId) {
            boolean isScheduled;
            Survey survey = (Survey)this._resolver.resolveById(surveyId);
            HashMap<String, String> surveyParams = new HashMap<String, String>();
            surveyParams.put("id", survey.getId());
            surveyParams.put("title", survey.getTitle());
            Date startDate = survey.getStartDate();
            Date endDate = survey.getEndDate();
            boolean bl = isScheduled = startDate != null || endDate != null;
            if (isScheduled) {
                Map objectModel = ContextHelper.getObjectModel((Context)this._context);
                Locale locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
                if (!(startDate != null && startDate.after(now.getTime()) || endDate != null && endDate.before(now.getTime()))) {
                    surveyParams.put("description", (String)this._getDateValidDescription(survey));
                    List validSurveys = (List)results.get("scheduled-valid-surveys");
                    validSurveys.add(surveyParams);
                } else if (endDate != null && endDate.before(now.getTime())) {
                    surveyParams.put("description", (String)this._getOutOfDateDescription(survey, endDate, locale));
                    List oodSurveys = (List)results.get("scheduled-outofdate-surveys");
                    oodSurveys.add(surveyParams);
                } else if (startDate != null && startDate.after(now.getTime())) {
                    surveyParams.put("description", (String)this._getForthComingDescription(survey, startDate, endDate, locale));
                    List forthcomingSurveys = (List)results.get("scheduled-forthcoming-surveys");
                    forthcomingSurveys.add(surveyParams);
                }
                List scheduledSurveys = (List)results.get("scheduled-surveys");
                scheduledSurveys.add(surveyParams);
            }
            List allrightSurveys = (List)results.get("allright-surveys");
            allrightSurveys.add(surveyParams);
        }
        return results;
    }

    private I18nizableText _getDateValidDescription(Survey survey) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(survey.getTitle());
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("scheduled-survey-valid-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }

    private I18nizableText _getOutOfDateDescription(Survey survey, Date endDate, Locale locale) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(survey.getTitle());
        DateFormat df = DateFormat.getDateInstance(1, locale);
        i18nParameters.add(endDate != null ? df.format(endDate) : "-");
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("scheduled-survey-outofdate-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }

    private I18nizableText _getForthComingDescription(Survey survey, Date startDate, Date endDate, Locale locale) {
        ArrayList<String> i18nParameters = new ArrayList<String>();
        i18nParameters.add(survey.getTitle());
        DateFormat df = DateFormat.getDateInstance(1, locale);
        i18nParameters.add(startDate != null ? df.format(startDate) : "-");
        i18nParameters.add(endDate != null ? df.format(endDate) : "-");
        I18nizableText ed = (I18nizableText)this._script.getParameters().get("scheduled-survey-forthcoming-description");
        return new I18nizableText(ed.getCatalogue(), ed.getKey(), i18nParameters);
    }
}

