/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.repository;

import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.survey.SurveyDateUtils;
import org.ametys.plugins.survey.data.SurveyAnswerDao;
import org.ametys.plugins.survey.data.SurveySession;
import org.ametys.plugins.survey.repository.Survey;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class SurveyAccessHelper
extends AbstractLogEnabled
implements Component,
ThreadSafe,
Serviceable {
    public static final String ROLE = SurveyAccessHelper.class.getName();
    protected SurveyAnswerDao _answerDao;

    public void service(ServiceManager manager) throws ServiceException {
        this._answerDao = (SurveyAnswerDao)((Object)manager.lookup(SurveyAnswerDao.ROLE));
    }

    public Date getSubmissionDate(String surveyId, UserIdentity user) {
        SurveySession userSession;
        Date alreadyTakenOn = null;
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getLogin()) && StringUtils.isNotBlank((CharSequence)user.getPopulationId()) && (userSession = this._answerDao.getSession(surveyId, user)) != null) {
            alreadyTakenOn = userSession.getSubmittedAt();
        }
        return alreadyTakenOn;
    }

    public String getCookieName(Request request, Survey survey) {
        Cookie cookie;
        String takenSurveys;
        Map cookieMap = request.getCookieMap();
        if (cookieMap.containsKey("org.ametys.survey.answeredSurveys") && StringUtils.isNotEmpty((CharSequence)(takenSurveys = (cookie = (Cookie)cookieMap.get("org.ametys.survey.answeredSurveys")).getValue()))) {
            String surveyId = survey.getId();
            ZonedDateTime reinitDate = survey.getReinitDate();
            String[] takenSurveyCookies = StringUtils.split((String)takenSurveys, (char)'|');
            for (int i = 0; i < takenSurveyCookies.length; ++i) {
                String takenSurveyCookie = takenSurveyCookies[i];
                String cookieSurveyDate = StringUtils.substringAfter((String)takenSurveyCookie, (String)"#");
                String cookieSurveyId = StringUtils.substringBefore((String)takenSurveyCookie, (String)"#");
                if (reinitDate != null) {
                    try {
                        ZonedDateTime cookieDate = SurveyDateUtils.parseZonedDateTime(cookieSurveyDate);
                        if (reinitDate.isBefore(cookieDate) && surveyId.equals(cookieSurveyId)) {
                            return "org.ametys.survey.answeredSurveys";
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    continue;
                }
                if (!surveyId.equals(cookieSurveyId)) continue;
                return "org.ametys.survey.answeredSurveys";
            }
        }
        return null;
    }
}

