/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.repository;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.survey.repository.AbstractSurveyElement;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestionFactory;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.apache.commons.lang3.StringUtils;

public class SurveyQuestion
extends AbstractSurveyElement<SurveyQuestionFactory> {
    public static final String OPTION_NAME_PREFIX = "opt-";
    private static final String __PROPERTY_LABEL = "ametys-internal:label";
    private static final String __PROPERTY_TITLE = "ametys-internal:title";
    private static final String __PROPERTY_TYPE = "ametys-internal:type";
    private static final String __PROPERTY_REGEXP = "ametys-internal:regexp";
    private static final String __PROPERTY_MANDATORY = "ametys-internal:mandatory";
    private static final String __PROPERTY_OTHER_OPTION = "ametys-internal:other-option";
    private static final String __NODE_NAME_OPTIONS = "ametys-internal:options";
    private static final String __NODE_NAME_COLUMNS = "ametys-internal:columns";
    private static final String __NODE_NAME_RULES = "ametys-internal:rules";
    private static final String __PROPERTY_RULE_TYPE = "ametys-internal:rule";
    private static final String __PROPERTY_RULE_OPTION = "ametys-internal:option";
    private static final String __PROPERTY_RULE_PAGE = "ametys-internal:page";

    public SurveyQuestion(Node node, String parentPath, SurveyQuestionFactory factory) {
        super(node, parentPath, factory);
    }

    public String getLabel() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_LABEL).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get label property", (Throwable)e);
        }
    }

    public void setLabel(String label) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_LABEL, label);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set label property", (Throwable)e);
        }
    }

    public String getTitle() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_TITLE).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get title property", (Throwable)e);
        }
    }

    public void setTitle(String title) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_TITLE, title);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set title property", (Throwable)e);
        }
    }

    public QuestionType getType() throws AmetysRepositoryException {
        try {
            return QuestionType.valueOf(this.getNode().getProperty(__PROPERTY_TYPE).getString());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get type property", (Throwable)e);
        }
    }

    public void setType(QuestionType type) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_TYPE, type.name());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set type property", (Throwable)e);
        }
    }

    public String getRegExpType() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_REGEXP).getString();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get regexp property", (Throwable)e);
        }
    }

    public void setRegExpType(String regexp) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_REGEXP, regexp);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set regexp property", (Throwable)e);
        }
    }

    public String getRegExpPattern() throws AmetysRepositoryException {
        String regexpType = this.getRegExpType();
        if (regexpType == null) {
            return null;
        }
        if ("int".equals(regexpType)) {
            return "^-?[0-9]+$";
        }
        if ("float".equals(regexpType)) {
            return "^-?[0-9]+(\\.[0-9]+)?$";
        }
        if ("email".equals(regexpType)) {
            return "^([a-zA-Z0-9_\\.\\-\\+])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$";
        }
        if ("phone".equals(regexpType)) {
            return "^(\\+?\\(?[0-9]{1,3}\\)?([\\s]?)(\\(0\\))?|0)([\\s]?)([0-9\\-\\+\\s]{4,})+$";
        }
        if ("date".equals(regexpType)) {
            return "^([12][0-9][0-9][0-9])-([01][0-9])-([0123][0-9])$";
        }
        if ("time".equals(regexpType)) {
            return "^([012][0-9]):([012345][0-9])$";
        }
        if ("datetime".equals(regexpType)) {
            return "^([12][0-9][0-9][0-9])-([01][0-9])-([0123][0-9]) ([012][0-9]):([012345][0-9])$";
        }
        return null;
    }

    public boolean isMandatory() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(__PROPERTY_MANDATORY).getBoolean();
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get mandatory property", (Throwable)e);
        }
    }

    public void setMandatory(boolean mandatory) throws AmetysRepositoryException {
        try {
            this.getNode().setProperty(__PROPERTY_MANDATORY, mandatory);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set mandatory property", (Throwable)e);
        }
    }

    public boolean hasOtherOption() {
        try {
            return this.getNode().getProperty(__PROPERTY_OTHER_OPTION).getBoolean();
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get other option property", (Throwable)e);
        }
    }

    public void setOtherOption(boolean other) {
        try {
            this.getNode().setProperty(__PROPERTY_OTHER_OPTION, other);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set other option property", (Throwable)e);
        }
    }

    public void setOptions(Map<String, String> options) throws AmetysRepositoryException {
        try {
            Node optsNode = this.getNode().getNode(__NODE_NAME_OPTIONS);
            NodeIterator itNode = optsNode.getNodes("ametys:*");
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                node.remove();
            }
            for (String name : options.keySet()) {
                Node optNode = optsNode.addNode("ametys:" + name, "ametys:survey-option");
                optNode.setProperty(__PROPERTY_TITLE, options.get(name));
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set options property", (Throwable)e);
        }
    }

    public Map<String, String> getOptions() throws AmetysRepositoryException {
        try {
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            NodeIterator itNode = this.getNode().getNode(__NODE_NAME_OPTIONS).getNodes("ametys:*");
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                if (!node.isNodeType("ametys:survey-option")) continue;
                String value = node.getProperty(__PROPERTY_TITLE).getString();
                options.put(node.getName().substring("ametys:".length()), value);
            }
            return options;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get options property", (Throwable)e);
        }
    }

    public void setColumns(Map<String, String> columns) throws AmetysRepositoryException {
        try {
            Node optsNode = this.getNode().getNode(__NODE_NAME_COLUMNS);
            NodeIterator itNode = optsNode.getNodes("ametys:*");
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                node.remove();
            }
            for (String name : columns.keySet()) {
                Node optNode = optsNode.addNode("ametys:" + name, "ametys:survey-option");
                optNode.setProperty(__PROPERTY_TITLE, columns.get(name));
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set columns property", (Throwable)e);
        }
    }

    public Map<String, String> getColumns() throws AmetysRepositoryException {
        try {
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            NodeIterator itNode = this.getNode().getNode(__NODE_NAME_COLUMNS).getNodes("ametys:*");
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                if (!node.isNodeType("ametys:survey-option")) continue;
                String value = node.getProperty(__PROPERTY_TITLE).getString();
                options.put(node.getName().substring("ametys:".length()), value);
            }
            return options;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get columns property", (Throwable)e);
        }
    }

    public void addRules(String option, SurveyRule.RuleType ruleType, String page) throws AmetysRepositoryException {
        try {
            if (!this.getNode().hasNode(__NODE_NAME_RULES)) {
                this.getNode().addNode(__NODE_NAME_RULES, "ametys:survey-rules");
            }
            Node rulesNode = this.getNode().getNode(__NODE_NAME_RULES);
            Node ruleNode = rulesNode.addNode(option, "ametys:survey-rule");
            ruleNode.setProperty(__PROPERTY_RULE_TYPE, ruleType.name());
            ruleNode.setProperty(__PROPERTY_RULE_OPTION, option);
            if (ruleType == SurveyRule.RuleType.JUMP || ruleType == SurveyRule.RuleType.SKIP) {
                ruleNode.setProperty(__PROPERTY_RULE_PAGE, page);
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to add rule", (Throwable)e);
        }
    }

    public boolean hasRule(String option) throws AmetysRepositoryException {
        try {
            Node rulesNode = this.getNode().getNode(__NODE_NAME_RULES);
            return rulesNode.hasNode(option);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to check if rule exists", (Throwable)e);
        }
    }

    public void deleteRule(String option) throws AmetysRepositoryException {
        try {
            Node rulesNode = this.getNode().getNode(__NODE_NAME_RULES);
            if (rulesNode.hasNode(option)) {
                rulesNode.getNode(option).remove();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to delete rule", (Throwable)e);
        }
    }

    public List<SurveyRule> getRules() throws AmetysRepositoryException {
        try {
            LinkedList<SurveyRule> rules = new LinkedList<SurveyRule>();
            NodeIterator itNode = this.getNode().getNode(__NODE_NAME_RULES).getNodes("*");
            while (itNode.hasNext()) {
                Node node = itNode.nextNode();
                if (!node.isNodeType("ametys:survey-rule")) continue;
                String option = node.getProperty(__PROPERTY_RULE_OPTION).getString();
                SurveyRule.RuleType type = SurveyRule.RuleType.valueOf(node.getProperty(__PROPERTY_RULE_TYPE).getString());
                String page = null;
                if (node.hasProperty(__PROPERTY_RULE_PAGE)) {
                    page = node.getProperty(__PROPERTY_RULE_PAGE).getString();
                }
                rules.add(new SurveyRule(option, type, page));
            }
            return rules;
        }
        catch (PathNotFoundException e) {
            return new LinkedList<SurveyRule>();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get rules property", (Throwable)e);
        }
    }

    public SurveyPage getSurveyPage() throws AmetysRepositoryException {
        return (SurveyPage)this.getParent();
    }

    public Survey getSurvey() throws AmetysRepositoryException {
        return this.getSurveyPage().getSurvey();
    }

    public SurveyQuestion copyTo(ModifiableTraversableAmetysObject parent, String name) throws AmetysRepositoryException {
        SurveyQuestion question = (SurveyQuestion)parent.createChild(name, "ametys:survey-question");
        question.setLabel(this.getLabel());
        question.setTitle(this.getTitle());
        question.setMandatory(this.isMandatory());
        question.setType(this.getType());
        String regExpType = this.getRegExpType();
        if (StringUtils.isNotEmpty((CharSequence)regExpType)) {
            question.setRegExpType(regExpType);
        }
        if (this.getType().equals((Object)QuestionType.MULTIPLE_CHOICE) || this.getType().equals((Object)QuestionType.SINGLE_CHOICE)) {
            question.setOtherOption(this.hasOtherOption());
        }
        question.setOptions(this.getOptions());
        question.setColumns(this.getColumns());
        for (SurveyRule rule : this.getRules()) {
            question.addRules(rule.getOption(), rule.getType(), rule.getPage());
        }
        this.copyPictureTo(question);
        return question;
    }

    public SurveyQuestion copyTo(ModifiableTraversableAmetysObject parent, String name, List<String> restrictTo) throws AmetysRepositoryException {
        return this.copyTo(parent, name);
    }

    public static enum QuestionType {
        FREE_TEXT,
        MULTILINE_FREE_TEXT,
        SINGLE_CHOICE,
        MULTIPLE_CHOICE,
        SINGLE_MATRIX,
        MULTIPLE_MATRIX;

    }
}

