/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.data;

/**
 * Class representing a survey answer, i.e. the response of a user to a question of the survey.
 */
public class SurveyAnswer
{
    
    /** The question ID. */
    protected String _questionId;
    
    /** The answer value. */
    protected String _value;
    
    /**
     * Build a SurveyAnswer object.
     */
    public SurveyAnswer()
    {
        this(null, null);
    }
    
    /**
     * Build a SurveyAnswer object.
     * @param questionId the question ID.
     * @param value the answer value.
     */
    public SurveyAnswer(String questionId, String value)
    {
        super();
        this._questionId = questionId;
        this._value = value;
    }

    /**
     * Get the questionId.
     * @return the questionId
     */
    public String getQuestionId()
    {
        return _questionId;
    }

    /**
     * Set the questionId.
     * @param questionId the questionId to set
     */
    public void setQuestionId(String questionId)
    {
        this._questionId = questionId;
    }

    /**
     * Get the value.
     * @return the value
     */
    public String getValue()
    {
        return _value;
    }

    /**
     * Set the value.
     * @param value the value to set
     */
    public void setValue(String value)
    {
        this._value = value;
    }
    
}
