/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.ametys.core.util.DateUtils;

public final class SurveyDateUtils {
    private SurveyDateUtils() {
    }

    public static ZonedDateTime asZonedDateTime(Calendar calendar) {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), calendar.getTimeZone().toZoneId());
        return zonedDateTime.withZoneSameInstant(ZoneId.of("UTC"));
    }

    public static Calendar asCalendar(ZonedDateTime zonedDateTime) {
        ZonedDateTime dateTimeOnUTC = zonedDateTime.withZoneSameInstant(ZoneId.of("UTC"));
        return GregorianCalendar.from(dateTimeOnUTC);
    }

    public static String zonedDateTimeToString(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(DateUtils.getISODateTimeFormatter());
    }

    public static ZonedDateTime parseZonedDateTime(String zonedDateTimeAsString) {
        return ZonedDateTime.parse(zonedDateTimeAsString, DateUtils.getISODateTimeFormatter());
    }
}

