/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.ametys.core.observation.Event;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.survey.dao.AbstractDAO;
import org.ametys.plugins.survey.dao.QuestionDAO;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class PageDAO
extends AbstractDAO {
    public static final String ROLE = PageDAO.class.getName();
    private Repository _repository;
    private QuestionDAO _questionDAO;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repository = (Repository)serviceManager.lookup("javax.jcr.Repository");
        this._questionDAO = (QuestionDAO)((Object)serviceManager.lookup(QuestionDAO.ROLE));
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getPage(String id) {
        SurveyPage page = (SurveyPage)this._resolver.resolveById(id);
        return this.getPage(page);
    }

    public Map<String, Object> getPage(SurveyPage page) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", page.getId());
        properties.put("label", page.getLabel());
        properties.put("title", page.getTitle());
        properties.put("description", page.getDescription());
        properties.putAll(this.getPictureInfo(page));
        return properties;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public boolean isLastPage(String id) {
        SurveyPage page = (SurveyPage)this._resolver.resolveById(id);
        Survey survey = (Survey)page.getParent();
        AmetysObjectIterable pages = survey.getChildren();
        AmetysObjectIterator it = pages.iterator();
        SurveyPage lastPage = null;
        while (it.hasNext()) {
            lastPage = (SurveyPage)((Object)it.next());
        }
        boolean isLast = lastPage != null && id.equals(lastPage.getId());
        return isLast;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> createPage(Map<String, Object> values) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String surveyId = StringUtils.defaultString((String)((String)values.get("surveyId")));
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        String label = StringUtils.defaultString((String)((String)values.get("label")));
        String originalName = NameHelper.filterName((String)label);
        Object name = originalName;
        int index = 2;
        while (survey.hasChild((String)name)) {
            name = originalName + "-" + index++;
        }
        SurveyPage page = (SurveyPage)survey.createChild((String)name, "ametys:survey-page");
        this._setValues(page, values);
        survey.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", page.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> editPage(Map<String, Object> values) {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = StringUtils.defaultString((String)((String)values.get("id")));
        SurveyPage page = (SurveyPage)this._resolver.resolveById(id);
        this._setValues(page, values);
        page.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", page.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", page.getId());
        result.put("surveyId", page.getSurvey().getId());
        return result;
    }

    private void _setValues(SurveyPage page, Map<String, Object> values) {
        page.setTitle(StringUtils.defaultString((String)((String)values.get("title"))));
        page.setLabel(StringUtils.defaultString((String)((String)values.get("label"))));
        page.setDescription(StringUtils.defaultString((String)((String)values.get("description"))));
        page.setPictureAlternative(StringUtils.defaultString((String)((String)values.get("picture-alternative"))));
        this.setPicture(page, StringUtils.defaultString((String)((String)values.get("picture"))));
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> copyPage(String surveyId, String pageId) {
        HashMap<String, String> result = new HashMap<String, String>();
        SurveyPage originalPage = (SurveyPage)this._resolver.resolveById(pageId);
        Survey parentSurvey = (Survey)this._resolver.resolveById(surveyId);
        String originalName = originalPage.getName();
        Object name = originalName;
        int index = 2;
        while (parentSurvey.hasChild((String)name)) {
            name = originalName + "-" + index++;
        }
        SurveyPage cPage = originalPage.copyTo((ModifiableTraversableAmetysObject)parentSurvey, (String)name);
        Survey originalSurvey = originalPage.getSurvey();
        if (!originalSurvey.getId().equals(parentSurvey.getId())) {
            this.updateReferencesAfterCopy(originalPage.getSurvey(), parentSurvey, cPage);
        }
        parentSurvey.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", parentSurvey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", cPage.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, String> deletePage(String id) {
        HashMap<String, String> result = new HashMap<String, String>();
        SurveyPage page = (SurveyPage)this._resolver.resolveById(id);
        Survey survey = (Survey)page.getParent();
        page.remove();
        this._removeReferencesFromPages(id);
        this._removeReferencesFromQuestions(id);
        survey.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", survey);
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        result.put("id", id);
        result.put("surveyId", survey.getId());
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> addRule(String id, String rule, String page) {
        SurveyPage surveyPage = (SurveyPage)this._resolver.resolveById(id);
        surveyPage.setRule(SurveyRule.RuleType.valueOf(rule), page);
        surveyPage.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", surveyPage.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        return new HashMap<String, Object>();
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> deleteRule(String id) {
        SurveyPage surveyPage = (SurveyPage)this._resolver.resolveById(id);
        surveyPage.deleteRule();
        surveyPage.saveChanges();
        HashMap<String, Survey> eventParams = new HashMap<String, Survey>();
        eventParams.put("survey", surveyPage.getSurvey());
        this._observationManager.notify(new Event("survey.modified", this._getCurrentUser(), eventParams));
        return new HashMap<String, Object>();
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getRule(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SurveyPage page = (SurveyPage)this._resolver.resolveById(id);
        SurveyRule rule = page.getRule();
        if (rule != null) {
            result.put("type", rule.getType().name());
            String pageId = rule.getPage();
            if (pageId != null) {
                try {
                    SurveyPage pageAO = (SurveyPage)this._resolver.resolveById(pageId);
                    result.put("page", pageId);
                    result.put("pageName", pageAO.getLabel());
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {}
            }
        } else {
            result = null;
        }
        return result;
    }

    @Callable(rights={"Plugins_Survey_Right_Handle"}, context="/cms")
    public Map<String, Object> getBranches(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SurveyPage page = (SurveyPage)this._resolver.resolveById(id);
        result.put("id", page.getId());
        ArrayList<Map<String, Object>> questions = new ArrayList<Map<String, Object>>();
        AmetysObjectIterable questionsAO = page.getChildren();
        int index = 1;
        for (SurveyQuestion question : questionsAO) {
            if (question.getType() == SurveyQuestion.QuestionType.SINGLE_CHOICE || question.getType() == SurveyQuestion.QuestionType.MULTIPLE_CHOICE) {
                questions.add(this._questionDAO.getRules(question.getId(), index));
            }
            ++index;
        }
        result.put("questions", questions);
        result.put("rule", this.getRule(id));
        return result;
    }

    private void _removeReferencesFromPages(String pageId) {
        Session session = null;
        String jcrQuery = "//element(*, ametys:survey-page)/element(*, ametys:survey-rule)[@ametys-internal:page='" + pageId + "']";
        try {
            session = this._repository.login();
            Query query = session.getWorkspace().getQueryManager().createQuery(jcrQuery, "xpath");
            NodeIterator nodes = query.execute().getNodes();
            while (nodes.hasNext()) {
                Node ruleNode = nodes.nextNode();
                Node pageNode = ruleNode.getParent();
                pageNode.getNode("ametys-internal:rule").remove();
                pageNode.getSession().save();
            }
        }
        catch (RepositoryException ex) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occurred executing the JCR query : " + jcrQuery, (Throwable)ex);
        }
    }

    private void _removeReferencesFromQuestions(String pageId) {
        Session session = null;
        String jcrQuery = "//element(*, ametys:survey-question)//element(*, ametys:survey-rule)[@ametys-internal:page='" + pageId + "']";
        try {
            session = this._repository.login();
            Query query = session.getWorkspace().getQueryManager().createQuery(jcrQuery, "xpath");
            NodeIterator nodes = query.execute().getNodes();
            while (nodes.hasNext()) {
                Node ruleNode = nodes.nextNode();
                Node questionNode = ruleNode.getParent().getParent();
                questionNode.getNode("ametys-internal:rules").getNode(ruleNode.getName()).remove();
                questionNode.getSession().save();
            }
        }
        catch (RepositoryException ex) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occurred executing the JCR query : " + jcrQuery, (Throwable)ex);
        }
    }
}

