/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class QuestionRulesGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("id");
        AmetysObject ao = this._resolver.resolveById(id);
        this.contentHandler.startDocument();
        if (ao instanceof SurveyQuestion) {
            this.saxRules((SurveyQuestion)ao, 0);
        } else if (ao instanceof SurveyPage) {
            this.saxRule((SurveyPage)ao);
        }
        this.contentHandler.endDocument();
    }

    public void saxRules(SurveyQuestion question, int number) throws SAXException {
        Map<String, String> options = question.getOptions();
        AttributesImpl attr = new AttributesImpl();
        attr = new AttributesImpl();
        attr.addCDATAAttribute("id", question.getId());
        attr.addCDATAAttribute("number", String.valueOf(number));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)attr);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)question.getTitle());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"rules");
        List<SurveyRule> rules = question.getRules();
        for (SurveyRule rule : rules) {
            AttributesImpl atts = new AttributesImpl();
            String option = rule.getOption();
            atts.addCDATAAttribute("option", option);
            atts.addCDATAAttribute("optionLabel", options.get(option));
            atts.addCDATAAttribute("type", rule.getType().name());
            String page = rule.getPage();
            if (page != null) {
                try {
                    SurveyPage pageAO = (SurveyPage)this._resolver.resolveById(page);
                    atts.addCDATAAttribute("page", page);
                    atts.addCDATAAttribute("pageName", pageAO.getLabel());
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                    // empty catch block
                }
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rule", (Attributes)atts);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"rules");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
    }

    public void saxRule(SurveyPage surveyPage) throws SAXException {
        SurveyRule rule = surveyPage.getRule();
        if (rule != null) {
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("type", rule.getType().name());
            String page = rule.getPage();
            if (page != null) {
                try {
                    atts.addCDATAAttribute("page", page);
                    SurveyPage pageAO = (SurveyPage)this._resolver.resolveById(page);
                    atts.addCDATAAttribute("pageName", pageAO.getLabel());
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                    // empty catch block
                }
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rule", (Attributes)atts);
        }
    }
}

