/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.data.SurveyAnswer;
import org.ametys.plugins.survey.data.SurveyAnswerDao;
import org.ametys.plugins.survey.data.SurveySession;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SurveySessionGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected SurveyAnswerDao _surveyDao;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._surveyDao = (SurveyAnswerDao)((Object)serviceManager.lookup(SurveyAnswerDao.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        int sessionId;
        try {
            sessionId = this.parameters.getParameterAsInteger("id");
        }
        catch (ParameterException e) {
            throw new ProcessingException("Session ID is mandatory.", (Throwable)e);
        }
        SurveySession surveySession = this._surveyDao.getSessionWithAnswers(sessionId);
        Survey survey = (Survey)this._resolver.resolveById(surveySession.getSurveyId());
        this.contentHandler.startDocument();
        this.saxSession(surveySession, survey, true);
        this.contentHandler.endDocument();
    }

    protected void saxSession(SurveySession surveySession, Survey survey, boolean withAnswers) throws SAXException {
        ZonedDateTime submittedAt = surveySession.getSubmittedAt().toInstant().atZone(ZoneId.systemDefault());
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", Integer.toString(surveySession.getId()));
        attrs.addCDATAAttribute("submittedAt", DateUtils.getISODateTimeFormatter().format(submittedAt));
        UserIdentity user = surveySession.getUser();
        if (user != null) {
            attrs.addCDATAAttribute("user", UserIdentity.userIdentityToString((UserIdentity)user));
        }
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"session", (Attributes)attrs);
        if (withAnswers) {
            this.saxAnswers(surveySession, survey);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"session");
    }

    protected void saxAnswers(SurveySession surveySession, Survey survey) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        Map<String, SurveyAnswer> answerMap = this.getAnswerMap(surveySession);
        for (SurveyQuestion question : survey.getQuestions()) {
            SurveyAnswer answer = answerMap.get(question.getName());
            attrs.clear();
            attrs.addCDATAAttribute("name", question.getName());
            attrs.addCDATAAttribute("title", question.getTitle());
            attrs.addCDATAAttribute("type", question.getType().toString());
            attrs.addCDATAAttribute("mandatory", Boolean.toString(question.isMandatory()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)attrs);
            if (answer != null) {
                Map<String, Set<String>> values = this.getValueMap(question, answer.getValue());
                for (String option : values.keySet()) {
                    attrs.clear();
                    attrs.addCDATAAttribute("name", option);
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"option", (Attributes)attrs);
                    for (String value : values.get(option)) {
                        attrs.clear();
                        attrs.addCDATAAttribute("value", value);
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"answer", (Attributes)attrs);
                    }
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"option");
                }
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
        }
    }

    protected Map<String, SurveyAnswer> getAnswerMap(SurveySession surveySession) {
        HashMap<String, SurveyAnswer> answerMap = new HashMap<String, SurveyAnswer>();
        for (SurveyAnswer surveyAnswer : surveySession.getAnswers()) {
            answerMap.put(surveyAnswer.getQuestionId(), surveyAnswer);
        }
        return answerMap;
    }

    protected Map<String, Set<String>> getValueMap(SurveyQuestion question, String value) {
        HashMap<String, Set<String>> values = new HashMap<String, Set<String>>();
        if (value != null) {
            switch (question.getType()) {
                case SINGLE_MATRIX: 
                case MULTIPLE_MATRIX: {
                    String[] entries;
                    for (String entry : entries = StringUtils.split((String)value, (char)';')) {
                        String[] keyValue = StringUtils.split((String)entry, (char)':');
                        if (keyValue.length != 2 || !StringUtils.isNotEmpty((CharSequence)keyValue[0])) continue;
                        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)keyValue[1], (char)',')));
                        values.put(keyValue[0], valueSet);
                    }
                    break;
                }
                case SINGLE_CHOICE: 
                case MULTIPLE_CHOICE: {
                    HashSet<String> valueSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)value, (char)',')));
                    values.put("values", valueSet);
                    break;
                }
                default: {
                    values.put("values", Collections.singleton(value));
                }
            }
        }
        return values;
    }
}

