/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.survey.data.SurveySession;
import org.ametys.plugins.survey.generators.SurveySessionGenerator;
import org.ametys.plugins.survey.repository.Survey;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SurveySessionsGenerator
extends SurveySessionGenerator {
    @Override
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String surveyId = this.parameters.getParameter("id", request.getParameter("id"));
        Survey survey = (Survey)this._resolver.resolveById(surveyId);
        List<SurveySession> sessions = this._surveyDao.getSessionsWithAnswers(surveyId);
        this.contentHandler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("surveyId", surveyId);
        attrs.addCDATAAttribute("surveyTitle", survey.getTitle());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"survey-sessions", (Attributes)attrs);
        for (SurveySession surveySession : sessions) {
            this.saxSession(surveySession, survey, true);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"survey-sessions");
        this.contentHandler.endDocument();
    }
}

