/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.generators;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.Binary;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.survey.dao.SurveyDAO;
import org.ametys.plugins.survey.repository.AbstractSurveyElement;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.plugins.survey.repository.SurveyPage;
import org.ametys.plugins.survey.repository.SurveyQuestion;
import org.ametys.plugins.survey.repository.SurveyRule;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SurveysGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected SurveyDAO _surveyDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._surveyDAO = (SurveyDAO)((Object)serviceManager.lookup(SurveyDAO.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = request.getParameter("siteName");
        String lang = request.getParameter("lang");
        String id = request.getParameter("id");
        boolean saxChildren = this.parameters.getParameterAsBoolean("saxChildren", true);
        this.contentHandler.startDocument();
        try {
            if (StringUtils.isEmpty((CharSequence)id) || id.equals("survey-root-node")) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"surveys");
                ModifiableTraversableAmetysObject rootNode = this.getSurveyRootNode(siteName, lang);
                AmetysObjectIterable surveys = rootNode.getChildren();
                for (Survey survey : surveys) {
                    this.toSAX(survey, false);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"surveys");
            } else {
                AmetysObject ao = this._resolver.resolveById(id);
                if (ao instanceof Survey) {
                    this.toSAX((Survey)ao, saxChildren);
                } else if (ao instanceof SurveyPage) {
                    this.toSAX((SurveyPage)ao, saxChildren, false);
                } else if (ao instanceof SurveyQuestion) {
                    this.toSAX((SurveyQuestion)ao);
                }
            }
        }
        catch (RepositoryException e) {
            throw new ProcessingException("Unable to get surveys", (Throwable)e);
        }
        this.contentHandler.endDocument();
    }

    protected void toSAX(Survey survey, boolean saxChildren) throws SAXException {
        String endingMessage;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", survey.getId());
        attrs.addCDATAAttribute("name", survey.getName());
        attrs.addCDATAAttribute("private", String.valueOf(this._surveyDAO.isPrivate(survey)));
        attrs.addCDATAAttribute("validated", String.valueOf(survey.isValidated()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"survey", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)survey.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)survey.getLabel());
        String description = survey.getDescription();
        if (description != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)description);
        }
        if ((endingMessage = survey.getEndingMessage()) != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"endingMessage", (String)endingMessage);
        }
        this.toSAXPicture(survey);
        if (saxChildren) {
            AmetysObjectIterable pages = survey.getChildren();
            for (SurveyPage page : pages) {
                this.toSAX(page, false, false);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"survey");
    }

    protected void toSAX(SurveyPage page, boolean saxChildren, boolean saxBranches) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", page.getId());
        attrs.addCDATAAttribute("name", page.getName());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"page", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)page.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)page.getLabel());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)page.getDescription());
        this.toSAXPicture(page);
        if (saxChildren) {
            AmetysObjectIterable questions = page.getChildren();
            for (SurveyQuestion question : questions) {
                this.toSAX(question);
            }
        }
        if (saxBranches) {
            this.saxBranches(page);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"page");
    }

    protected void saxBranches(SurveyPage page) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"branches");
        AmetysObjectIterable questions = page.getChildren();
        for (SurveyQuestion question : questions) {
            List<SurveyRule> rules = question.getRules();
            for (SurveyRule rule : rules) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("id", question.getId());
                attr.addCDATAAttribute("name", question.getName());
                attr.addCDATAAttribute("value", rule.getOption());
                SurveyRule.RuleType type = rule.getType();
                attr.addCDATAAttribute("type", type.name());
                if (type == SurveyRule.RuleType.JUMP) {
                    attr.addCDATAAttribute("page", rule.getPage());
                }
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"rule", (Attributes)attr);
            }
        }
        SurveyRule rule = page.getRule();
        if (rule != null) {
            AttributesImpl attr = new AttributesImpl();
            SurveyRule.RuleType type = rule.getType();
            attr.addCDATAAttribute("type", type.name());
            if (type == SurveyRule.RuleType.JUMP) {
                attr.addCDATAAttribute("page", rule.getPage());
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"page-rule", (Attributes)attr);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"branches");
    }

    protected void toSAX(SurveyQuestion question) throws SAXException {
        Map<String, String> columns;
        Map<String, String> options;
        String pattern;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", question.getId());
        attrs.addCDATAAttribute("name", question.getName());
        attrs.addCDATAAttribute("type", question.getType().name());
        attrs.addCDATAAttribute("mandatory", String.valueOf(question.isMandatory()));
        attrs.addCDATAAttribute("modifiable", String.valueOf(!question.getSurvey().isValidated()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"question", (Attributes)attrs);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)question.getLabel());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)question.getTitle());
        this.toSAXPicture(question);
        String regExpType = question.getRegExpType();
        if (StringUtils.isNotEmpty((CharSequence)regExpType)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"regexp", (String)regExpType);
        }
        if (StringUtils.isNotEmpty((CharSequence)(pattern = question.getRegExpPattern()))) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"pattern", (String)pattern);
        }
        if ((options = question.getOptions()).size() > 0) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("other-option", String.valueOf(question.hasOtherOption()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"options", (Attributes)attr);
            for (String value : options.keySet()) {
                attr = new AttributesImpl();
                attr.addCDATAAttribute("value", value);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"option", (Attributes)attr, (String)options.get(value));
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"options");
        }
        if ((columns = question.getColumns()).size() > 0) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"columns");
            for (String value : columns.keySet()) {
                AttributesImpl attr = new AttributesImpl();
                attr.addCDATAAttribute("value", value);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"column", (Attributes)attr, (String)columns.get(value));
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"columns");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"question");
    }

    protected void toSAXPicture(AbstractSurveyElement elmt) throws SAXException {
        String pictureType = elmt.getPictureType();
        if (pictureType != null) {
            AttributesImpl attrsPicture = new AttributesImpl();
            attrsPicture.addCDATAAttribute("pictureType", pictureType);
            if (pictureType.equals("resource")) {
                String resourceId = elmt.getResourcePictureId();
                attrsPicture.addCDATAAttribute("pictureId", resourceId);
                try {
                    Resource resource = (Resource)this._resolver.resolveById(resourceId);
                    attrsPicture.addCDATAAttribute("pictureName", resource.getName());
                    attrsPicture.addCDATAAttribute("pictureSize", Long.toString(resource.getLength()));
                    attrsPicture.addCDATAAttribute("imageType", "explorer");
                }
                catch (UnknownAmetysObjectException e) {
                    this.getLogger().error("The resource of id'" + resourceId + "' does not exist anymore. The picture for element survey of id '" + elmt.getId() + "' will be ignored.", (Throwable)e);
                }
            } else if (pictureType.equals("external")) {
                Binary picMeta = elmt.getExternalPicture();
                attrsPicture.addCDATAAttribute("picturePath", "picture");
                attrsPicture.addCDATAAttribute("pictureName", picMeta.getFilename());
                attrsPicture.addCDATAAttribute("pictureSize", Long.toString(picMeta.getLength()));
                attrsPicture.addCDATAAttribute("imageType", "metadata");
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"picture", (Attributes)attrsPicture);
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"pictureAlternative", (String)StringUtils.defaultString((String)elmt.getPictureAlternative()));
    }

    protected ModifiableTraversableAmetysObject getSurveyRootNode(String siteName, String lang) throws RepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = this._siteManager.getSite(siteName).getRootPlugins();
        ModifiableTraversableAmetysObject surveyNode = null;
        surveyNode = !pluginsNode.hasChild("survey") ? (ModifiableTraversableAmetysObject)((ModifiableTraversableAmetysObject)pluginsNode.createChild("survey", "ametys:unstructured")).createChild("ametys:surveys", "ametys:unstructured") : (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys");
        if (!surveyNode.hasChild(lang)) {
            surveyNode.createChild(lang, "ametys:unstructured");
            ((JCRAmetysObject)pluginsNode).getNode().getSession().save();
        }
        return (ModifiableTraversableAmetysObject)pluginsNode.getChild("survey/ametys:surveys/" + lang);
    }
}

