/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.survey.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.data.SurveyAnswerDao;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SurveyStatisticsProvider
implements StatisticsProvider,
Serviceable,
PluginAware {
    private String _id;
    private AmetysObjectResolver _ametysObjectResolver;
    private SurveyAnswerDao _surveyAnswerDAO;

    public void service(ServiceManager manager) throws ServiceException {
        this._ametysObjectResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._surveyAnswerDAO = (SurveyAnswerDao)((Object)manager.lookup(SurveyAnswerDao.ROLE));
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public Statistics getStatistics() {
        List<String> surveyIds = this._getSurveyIds();
        List<Map<String, Object>> allSessionCount = this._surveyAnswerDAO.getAllSessionCount();
        List<Long> counts = allSessionCount.stream().filter(m -> surveyIds.contains(m.get("surveyId"))).map(m -> m.get("count(*)")).map(Long.class::cast).sorted().toList();
        long count = counts.stream().mapToLong(l -> l).sum();
        return new StatisticsNode(this._id, new I18nizableText("plugin.survey", "PLUGINS_SURVEY_USAGESTATISTICS_LABEL"), "ametysicon-desktop-clipboard-list", null, List.of(new StatisticsNode("count", new I18nizableText("plugin.survey", "PLUGINS_SURVEY_USAGESTATISTICS_COUNT_LABEL"), "ametysicon-maths-number-zero-one", (Object)surveyIds.size(), List.of(new StatisticsValue("count", new I18nizableText("plugin.survey", "PLUGINS_SURVEY_USAGESTATISTICS_COUNT_WITH_A_VALUE_LABEL"), "ametysicon-maths-number-zero-one", (Object)counts.size())), true), new StatisticsNode("answers", new I18nizableText("plugin.survey", "PLUGINS_SURVEY_USAGESTATISTICS_ANSWERS_LABEL"), "ametysicon-art-pencil", (Object)count, List.of(new StatisticsValue("max", new I18nizableText("plugin.survey", "PLUGINS_SURVEY_USAGESTATISTICS_ANSWERS_MAX_LABEL"), "ametysicon-sort51", (Object)(counts.size() > 0 ? counts.get(counts.size() - 1) : 0L)), new StatisticsValue("median", new I18nizableText("plugin.survey", "PLUGINS_SURVEY_USAGESTATISTICS_ANSWERS_MEDIAN_LABEL"), "ametysicon-maths-window-symbol-x", (Object)(counts.size() > 0 ? counts.get(counts.size() / 2) : 0L))), false)), true);
    }

    private List<String> _getSurveyIds() {
        ArrayList<String> surveyIds = new ArrayList<String>();
        try (AmetysObjectIterable nodes = this._ametysObjectResolver.query("//element(*, ametys:survey)");){
            for (AmetysObject ametysObject : nodes) {
                Survey survey = (Survey)ametysObject;
                surveyIds.add(survey.getId());
            }
        }
        return surveyIds;
    }
}

