<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:math="java.lang.Math" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

 	<xsl:import href="workspace:web://stylesheets/variables.xsl"/> 
	<xsl:import href="plugin:survey://stylesheets/survey2html.xsl"/>
	
	<xsl:param name="preview">true</xsl:param>
	
	<xsl:template match="/">
		<html>
			<head>
  				<script type="text/javascript" src="{ametys:pluginResourceURL('jquery', 'js/jquery.min.js')}"></script>
  				
  				<script type="text/javascript">
                	$j = jQuery.noConflict();
                	
                	function previewGotoPage(id, qId)
                	{
                		var pagePositions = {};
                		
                		// Hide all pages
                		$j("#survey-<xsl:value-of select="$uniqueId"/>-start-page").hide();
                		<xsl:for-each select="survey//page">
                			pagePositions['<xsl:value-of select="@id"/>'] = '<xsl:value-of select="position()"/>';
                			// Hide page
                			$j("#survey-<xsl:value-of select="$uniqueId"/>-page-<xsl:value-of select="position()"/>").hide();
                		</xsl:for-each>
                		
                		// Show the current page
                		if (id != null)
                		{
                			$j("#survey-<xsl:value-of select="$uniqueId"/>-mandatory-hint").show();
                			$j("#survey-<xsl:value-of select="$uniqueId"/>-page-" + pagePositions[id]).show();
                		}
                		else
                		{
                			$j("#survey-<xsl:value-of select="$uniqueId"/>-mandatory-hint").hide();
                			$j("#survey-<xsl:value-of select="$uniqueId"/>-start-page").show();
                		}
                		
                		if (qId != null)
                		{
	                		var qNames = {};
	                		<xsl:for-each select="survey//question">
	                			qNames['<xsl:value-of select="@id"/>'] = '<xsl:value-of select="@name"/>';
	                			$j("#survey-<xsl:value-of select="$uniqueId"/>-q-<xsl:value-of select="@name"/>").removeClass("selected");
	                		</xsl:for-each>
	                		
	                		// Select the current question
	                		$j("#survey-<xsl:value-of select="$uniqueId"/>-q-" + qNames[qId]).addClass("selected");
	                		var offset = $j("#survey-<xsl:value-of select="$uniqueId"/>-q-" + qNames[qId]).offset();
	                		var top = offset &amp;&amp; offset.top;
	                		
	                		window.scrollTo(0, top);
                		}
                	}
                </script>

  				<link type="text/css" href="{ametys:pluginResourceURL('survey', 'css/preview.css')}" rel="stylesheet" media="print, screen" />
  				
  				<xsl:call-template name="head-scripts"/>
			</head>

			<body>
				<div class="survey">
		    		<h1><xsl:value-of select="survey/title"/></h1>
					<xsl:call-template name="view"/>
				</div>
			</body>
		</html>
	</xsl:template>
		
</xsl:stylesheet>