/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

function _survey_getCookieValue(name) {
    var nameEq = name + '=';
    var cookies = document.cookie.split(';');
    for(var i = 0;i < cookies.length ; i++) {
        var c = cookies[i];
        while (c.charAt(0) == ' ')
        {
            c = c.substring(1, c.length);
        }
        if (c.indexOf(nameEq) == 0)
        {
            if (c.charAt(nameEq.length) == '"' && c.charAt(c.length-1) == '"')
            {
                return c.substring(nameEq.length + 1, c.length - 1);
            }
            else
            {
                return c.substring(nameEq.length, c.length);
            }
        }
    }
    return null;
}

/**
 * True if the anonymous user has already answered to the survey
 * @param {String} surveyId the survey id
 * @param {Date} reinitDate The last date of the re-initialization of the survey. Can be null.
 */
function survey_alreadyTaken(surveyId, reinitDate) {
    var alreadyTaken = _survey_getCookieValue('org.ametys.survey.answeredSurveys');
    if (alreadyTaken != null)
    {
    	// We check all cookies for the taken surveys
        var takenSurveyCookies = alreadyTaken.split('|');
        for (var i in takenSurveyCookies)
    	{
        	// A survey cookie is constructed as surveyId#creationCookieDate when the anonymous user has answered
        	var takenSurveyCookie = takenSurveyCookies[i].split('#');
        	var cookieSurveyId = takenSurveyCookie[0];
        	var cookieSurveyDate = takenSurveyCookie[1];
        	
        	if (reinitDate) // The survey has been reinitialized at least one time
        	{
        		// So we compare the last re-initialization date with the date of creation of the cookie
                if (new Date(reinitDate) <= new Date(cookieSurveyDate))
        		{
                	// If the re-initialization date is before the date of creation of the cookie, the cookie is valid and we check the survey id
                    if (cookieSurveyId == surveyId)
        			{
        				return true;
        			}
        		}
        		
        	}
        	else if (cookieSurveyId == surveyId)
        	{
        		return true;
        	}
        	
    	}
        
    }
    return false;
}

function survey_begin (id, surveyId, context)
{
	$j("#survey-" + id + "-mandatory-hint").show();
	$j("#survey-" + id + "-page-1").show();
	$j("#survey-" + id + "-start-page").hide();
	
	survey_arrange_matrix(id, "survey-" + id + "-page-1");
	survey_save_page(surveyId, 1, context);
}

function survey_end (id, pos, surveyId, context)
{
	var errors = eval('checkForm_' + id + '_' + pos + '()');
	if (errors.length> 0)
	{
		survey_display_errors (id, pos, errors);
		return;
	}
	
	survey_delete_form_values(surveyId, context);
	surveyStopStorage = true;
    
	// Submit form
    $j("#survey-" + id + "-form").submit();
}

function survey_nextpage(id, pos, last, surveyId, context)
{
	var errors = eval('checkForm_' + id + '_' + pos + '()');
	if (errors.length> 0)
	{
		survey_display_errors (id, pos, errors);
		return;
	}
	
	// Branches 
	var branch = eval('branches_' + id + '_' + pos + '()');
	if (branch == -1)
	{
		// No branch
		next = pos + 1;
	}
	else if (branch == 0)
	{
		// Finish survey
		next = last;
	}
	else
	{
		next = branch;
	}

	$j("#survey-" + id + "-page-" + pos).hide();
	$j("#survey-" + id + "-page-" + next).show();
	if (pos + 1 == last)
	{
		$j("#survey-" + id + "-mandatory-hint").hide();
	}
	
	$j(window).scrollTop($j("#survey-" + id + "-page-" + next).position().top);
	survey_arrange_matrix(id, "survey-" + id + "-page-" + next);
	
	survey_precedePages[id].push(pos);
	survey_save_page(surveyId, next, context);
}

function survey_previouspage(id, pos, surveyId, context)
{
	$j("#survey-" + id + "-mandatory-hint").show();

	var precedePage;
	if (survey_precedePages[id].length> 0)
	{
		precedePage = survey_precedePages[id][survey_precedePages[id].length -1];
		// Remove last page
		survey_precedePages[id].splice(survey_precedePages[id].length -1, 1);
	}
	else
	{
		precedePage = pos - 1;
	}
	
	$j("#survey-" + id + "-page-" + pos).hide();
	$j("#survey-" + id + "-page-" + precedePage).show();
	
	$j(window).scrollTop($j("#survey-" + id + "-page-" + precedePage).position().top);
	survey_save_page(surveyId, precedePage, context);
}

function survey_input_radio_empty (formId, name)
{
	var inputs = $j('#' + formId + ' input[name=' + name + ']');
	for (var i=0; i < inputs.length; i++)
	{
		if (inputs.get(i).checked)
		{
			return false;
		}
	}
	return true;
}

function survey_reset_errors (id)
{
	$j('#survey-' + id).find('.error').remove();
	$j('#survey-' + id).find('div.invalid').removeClass('invalid');
	$j('#survey-' + id).find('fieldset.invalid').removeClass('invalid');
}

function survey_regexp_error_msg (type)
{
	var msg = "{{i18n PLUGINS_SURVEY_FORM_ERROR_TEXT_REGEXP}}";
	if (type == 'email')
	{
		msg = "{{i18n PLUGINS_SURVEY_FORM_ERROR_TEXT_EMAIL}}";
	}
	else if (type == 'int')
	{
		msg = "{{i18n PLUGINS_SURVEY_FORM_ERROR_TEXT_INTEGER}}";
	}
	else if (type == 'float')
	{
		msg = "{{i18n PLUGINS_SURVEY_FORM_ERROR_TEXT_FLOAT}}";
	}
	else if (type == 'phone')
	{
		msg = "{{i18n PLUGINS_SURVEY_FORM_ERROR_TEXT_PHONE}}";
	}
	return msg;
}

function survey_display_errors (id, pos, errors)
{
	$j('#survey-' + id + '-page-' + pos).before('<div class="error"><p>{{i18n PLUGINS_SURVEY_FORM_ERRORS}}</p><ul></ul></div>');
	for (var i=0; i < errors.length; i++)
	{
		$j('div.error ul').append('<li>' + errors[i].label + " : " + errors[i].message + '</li>');
	}
	
	$j(window).scrollTop($j("#survey-" + id + " .error").position().top);
}

function survey_arrange_matrix (id, id2)
{
	var maxWidth;

	function setFreeCell(index, element)
	{
		element.style.width = 'auto';
	}

	function setMaxWidthOnCol(index, element)
	{
		maxWidth = 0;

		var parentTables = $j(element).parents('div.field').find('table');
		$j('td:eq(' + index + ')', parentTables).each(getMaxWidthOnCell);
		$j('td:eq(' + index + ')', parentTables).each(setMaxWidthOnCell);
	}
	
	function getMaxWidthOnCell(index, element)
	{
		var w = $j(element).width(); 
		maxWidth = Math.max(w, maxWidth);
	}

	function setMaxWidthOnCell(index, element)
	{
		$j(element).width(maxWidth);
	}
	
	$j('#survey-' + id + ' #' + id2 + ' div.question fieldset div.field table td').each(setFreeCell);
	$j('#survey-' + id + ' #' + id2 + ' div.question').each (function (index, elmt) {
		$j(elmt).find('fieldset div.field table:eq(0) td').each(setMaxWidthOnCol);
	})
}

function survey_otheropt_onkeyup (input, id)
{
	var checked = input.value != '';
	$j('#' + id).get(0).checked = checked;
}

/********************************* Cookie survey form ****************************************************/
var surveyStopStorage = false;

// Save all the form values
function survey_save_form_values (surveyId, uniqueId)
{
    if (surveyStopStorage) return;
    
	var formJson = survey_get_formJson ();
	if (formJson[surveyId] == null)
	{
		formJson[surveyId] = {};
	}
	
	var surveyFormJson = formJson[surveyId];
	var form = $j("#survey-" + uniqueId + "-form");
	surveyFormJson["values"] = form.serializeArray();
	
    localStorage['org.ametys.survey.formSurveys'] = JSON.stringify(formJson);
}

// Save the current page
function survey_save_page (surveyId, pos, context)
{
    if (surveyStopStorage) return;
    
	if (context == 'front')
	{
		var formJson = survey_get_formJson ();
		if (formJson[surveyId] == null)
		{
			formJson[surveyId] = {};
		}
		
		var surveyFormJson = formJson[surveyId];
		surveyFormJson["current-page"] = pos;
		
        localStorage['org.ametys.survey.formSurveys'] = JSON.stringify(formJson);
	}
}

// Get the form values from the localStorage
function survey_get_formJson ()
{
	var formJson = localStorage['org.ametys.survey.formSurveys'];
	if (formJson != null)
	{
		return JSON.parse(formJson);
	}
	
	return {};
}

// Go to the page pre-selected from localStorage
function survey_go_to_page (uniqueId, surveyFormJson, last)
{
	var pos = surveyFormJson["current-page"];
	if (pos)
	{
		$j("#survey-" + uniqueId + "-mandatory-hint").show();
		$j("#survey-" + uniqueId + "-page-" + pos).show();
		$j("#survey-" + uniqueId + "-start-page").hide();
		
		if (pos == last)
		{
			$j("#survey-" + uniqueId + "-mandatory-hint").hide();
		}
		
		survey_arrange_matrix(uniqueId, "survey-" + uniqueId + "-page-" + pos);
	}
}

// Fill the form with the values pre-selected from localStorage
function survey_fill_form (surveyId, uniqueId, last)
{
	var formJson = survey_get_formJson();
	if (formJson[surveyId] != null)
	{
		var surveyFormJson = formJson[surveyId];
		var values = surveyFormJson["values"];
		var form = $j("#survey-" + uniqueId + "-form");
		// browse all values from the cookie
		for (var ind in values)
		{
			var object = values[ind];
			// get the input in the form link to the name 'object.name'
			var input = $j('[name='+object.name+']', form);
			if (object.value != "")
			{
				// check the type of the input
				switch(input.attr("type"))  
			    {  
			        case "text" :   
			        case "hidden":  
			        	input.val(object.value);
			        break;   
			        case "radio" : 
		        	case "checkbox":   
			        	input.each(function()
	        			{
			        		if ($j(this).attr('value') == object.value) 
			        		{  
			        			//We trigger a click event because with Jqtranform, .attr('checked', true) doesn't work
			        			$j(this).trigger('click');
			        		} 
		        		});   
			        break;  
			        default:
			        	// the default case for textarea or select (to handle)
			        	input.val(object.value);
			    }  
			}
		}
		
		survey_go_to_page (uniqueId, surveyFormJson, last);
	}
}

// Delete form survey from localStorage
function survey_delete_form_values (surveyId, context)
{
	if (context == 'front')
	{
		var formJson = survey_get_formJson();
		if (formJson[surveyId])
		{
			delete formJson[surveyId];
            localStorage['org.ametys.survey.formSurveys'] = JSON.stringify(formJson);
		}
	}
}

// Returns a function, that, as long as it continues to be invoked, will not
// be triggered. The function will be called after it stops being called for
// N milliseconds. If `immediate` is passed, trigger the function on the
// leading edge, instead of the trailing.
// cf https://davidwalsh.name/javascript-debounce-function
function survey_debounce(func, wait, immediate) {
	var timeout;
	return function() {
		var context = this, args = arguments;
		var later = function() {
			timeout = null;
			if (!immediate) func.apply(context, args);
		};
		var callNow = immediate && !timeout;
		clearTimeout(timeout);
		timeout = setTimeout(later, wait);
		if (callNow) func.apply(context, args);
	};
};
