<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="contextPath" />
    <xsl:param name="cms-context" />
    <xsl:param name="plugin" />
    <xsl:param name="site" />
    
    <xsl:variable name="rowspan-max">
    	<xsl:choose>
    		<xsl:when test="/xml/survey//question[@type = 'MULTIPLE_MATRIX']">3</xsl:when>
    		<xsl:when test="/xml/survey//question[@type = 'SINGLE_MATRIX'] or /xml/survey//question[@type = 'MULTIPLE_CHOICE']">2</xsl:when>
    		<xsl:otherwise>1</xsl:otherwise>
    	</xsl:choose>
    </xsl:variable>
    
    <xsl:template match="/xml">
        <html>
            <head/>
            <body>
                <table>
                    <thead>
                        <tr>
                            <th rowspan="{$rowspan-max}"><i18n:text i18n:key="PLUGINS_SURVEY_SESSIONS_EXPORT_SUBMITTED_AT"/></th>
                            <xsl:apply-templates select="survey//question" mode="header"/>
                        </tr>
                        <xsl:if test="$rowspan-max &gt; 1">
                        	<tr><xsl:apply-templates select="survey//question" mode="header-secondrow"/></tr>
                        </xsl:if>
                        <xsl:if test="$rowspan-max &gt; 2">
	                        <tr>
	                            <xsl:apply-templates select="survey//question" mode="header-thirdrow"/>
	                        </tr>
	                    </xsl:if>
                    </thead>
                    <tbody>
                       <xsl:apply-templates select="survey-sessions/session"/>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="question" mode="header">
        <th>
            <xsl:choose>
            	<xsl:when test="@type = 'MULTIPLE_MATRIX'">
            		<xsl:attribute name="colspan">
                        <xsl:value-of select="count(options/option) * count(columns/column)"/>
                    </xsl:attribute>
            	</xsl:when>
                <xsl:when test="@type = 'SINGLE_MATRIX' or @type = 'MULTIPLE_CHOICE'">
                    <xsl:attribute name="colspan">
                        <xsl:value-of select="count(options/option) + count(options[@other-option='true'])"/>
                    </xsl:attribute>
                    <xsl:attribute name="rowspan"><xsl:value-of select="$rowspan-max - 1"/></xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="rowspan"><xsl:value-of select="$rowspan-max"/></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="title"/>
        </th>
    </xsl:template>
    
    <xsl:template match="question" mode="header-secondrow">
    	<xsl:choose>
    		<xsl:when test="$rowspan-max = 2 and (@type = 'SINGLE_MATRIX' or @type = 'MULTIPLE_CHOICE')">
    			<xsl:for-each select="options/option">
	                <th><xsl:value-of select="."/></th>
            	</xsl:for-each>
            	<xsl:if test="@type = 'MULTIPLE_CHOICE' and options/@other-option = 'true'">
            		<th><i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_OTHER_OPTION"/></th>
            	</xsl:if>
    		</xsl:when>
    		<xsl:when test="@type = 'MULTIPLE_MATRIX'">
    			<xsl:for-each select="options/option">	
    				<th>
    					<xsl:attribute name="colspan"><xsl:value-of select="count(../../columns/column)"/></xsl:attribute>
                   		<xsl:value-of select="."/>
                	</th>
    			</xsl:for-each>
    		</xsl:when>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="question" mode="header-thirdrow">
    	<xsl:choose>
    		<xsl:when test="$rowspan-max = 3 and (@type = 'SINGLE_MATRIX' or @type = 'MULTIPLE_CHOICE')">
    			<xsl:for-each select="options/option">
	                <th><xsl:value-of select="."/></th>
            	</xsl:for-each>
            	<xsl:if test="@type = 'MULTIPLE_CHOICE' and options/@other-option = 'true'">
            		<th><i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_OTHER_OPTION"/></th>
            	</xsl:if>
    		</xsl:when>
    		<xsl:when test="@type = 'MULTIPLE_MATRIX'">
    			<xsl:for-each select="options/option">	
	    			<xsl:for-each select="../../columns/column">	
	    				<th><xsl:value-of select="."/></th>
	    			</xsl:for-each>
	    		</xsl:for-each>
    		</xsl:when>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="session">
        <tr>
            <td>
                <xsl:if test="normalize-space(@submittedAt) != ''">
                    <i18n:date-time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="medium"><xsl:value-of select="@submittedAt"/></i18n:date-time>
                </xsl:if>
            </td>
            <xsl:apply-templates select="/xml/survey//question">
                <xsl:with-param name="sessionId" select="@id"/>
            </xsl:apply-templates>
        </tr>
    </xsl:template>
    
    <xsl:template match="question[@type = 'FREE_TEXT' or @type = 'MULTILINE_FREE_TEXT']">
        <xsl:param name="sessionId"/>
        <xsl:variable name="questionName" select="@name"/>
        <td>
            <xsl:value-of select="/xml/survey-sessions/session[@id = $sessionId]/question[@name = $questionName]/option/answer/@value"/>
        </td>
    </xsl:template>
    
    <xsl:template match="question[@type = 'SINGLE_CHOICE']">
        <xsl:param name="sessionId"/>
        
        <xsl:variable name="questionName" select="@name"/>
        <td>
        	<xsl:variable name="answer" select="/xml/survey-sessions/session[@id = $sessionId]/question[@name = $questionName]/option/answer/@value"/>
            <xsl:choose>
            	<xsl:when test="options/option[@value = $answer]">
            		<xsl:value-of select="options/option[@value = $answer]"/>
            	</xsl:when>
            	<xsl:otherwise>
            		<!-- Other -->
            		<i18n:text i18n:key="PLUGINS_SURVEY_STATISTICS_OTHER_OPTION"/><xsl:text>: </xsl:text><xsl:value-of select="$answer"/>
            	</xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
    
    <xsl:template match="question[@type = 'MULTIPLE_CHOICE']">
        <xsl:param name="sessionId"/>
        
        <xsl:variable name="questionName" select="@name"/>
        
        <xsl:for-each select="options/option">
        	<xsl:variable name="optVal" select="@value"/>
        	
        	<td>
        		<xsl:choose>
        			<xsl:when test="/xml/survey-sessions/session[@id = $sessionId]/question[@name = $questionName]/option/answer[@value = $optVal]">Oui</xsl:when>
        			<xsl:otherwise>Non</xsl:otherwise>
        		</xsl:choose>
        	</td>
        </xsl:for-each>
        
        <!-- Other option -->
        <xsl:if test="options/@other-option = 'true'">
        	<td>
        		<xsl:for-each select="/xml/survey-sessions/session[@id = $sessionId]/question[@name = $questionName]/option/answer">
	            	<xsl:variable name="answer" select="@value"/>
	            	
	            	<xsl:if test="not(/xml/survey//question[@name = $questionName]/options/option[@value = $answer])">
	            		<xsl:value-of select="$answer"/>
	            	</xsl:if>
	            </xsl:for-each> 
        	</td>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="question[@type = 'SINGLE_MATRIX']">
        <xsl:param name="sessionId"/>
        <xsl:variable name="questionName" select="@name"/>
        
        <xsl:for-each select="options/option">
            <xsl:variable name="optVal" select="@value"/>
            
            <xsl:variable name="answer" select="/xml/survey-sessions/session[@id = $sessionId]/question[@name = $questionName]/option[@name = $optVal]/answer/@value"/>
            
            <td>
	            <xsl:value-of select="ancestor::question/columns/column[@value = $answer]"/>
            </td>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="question[@type = 'MULTIPLE_MATRIX']">
        <xsl:param name="sessionId"/>
        <xsl:variable name="questionName" select="@name"/>
        
        <xsl:for-each select="options/option">
            <xsl:variable name="optVal" select="@value"/>
            
            <xsl:for-each select="ancestor::question/columns/column">
            	<xsl:variable name="colVal" select="@value"/>
            	<td>
	        		<xsl:choose>
	        			<xsl:when test="/xml/survey-sessions/session[@id = $sessionId]/question[@name = $questionName]/option[@name = $optVal]/answer[@value = $colVal]">Oui</xsl:when>
	        			<xsl:otherwise>Non</xsl:otherwise>
	        		</xsl:choose>
	        	</td>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>
