/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.actions;

import java.util.Map;

import javax.jcr.RepositoryException;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.core.observation.AbstractNotifierAction;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.web.repository.site.SiteManager;

/**
 * Abstract action for manipulate survey
 *
 */
public abstract class AbstractSurveyAction extends AbstractNotifierAction
{
    /** Ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    
    /** The site manager */
    protected SiteManager _siteManager;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _siteManager = (SiteManager) serviceManager.lookup(SiteManager.ROLE);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public abstract Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception;

    /**
     * Get the root node for surveys
     * @param siteName the site name
     * @param lang the language
     * @return the root node
     * @throws RepositoryException if an error occurs while manipulating the repository
     */
    protected ModifiableTraversableAmetysObject getSurveyRootNode (String siteName, String lang) throws RepositoryException
    {
        ModifiableTraversableAmetysObject pluginsNode = _siteManager.getSite(siteName).getRootPlugins();
        
        ModifiableTraversableAmetysObject surveyNode = null;
        if (!pluginsNode.hasChild("survey"))
        {
            surveyNode = ((ModifiableTraversableAmetysObject) pluginsNode.createChild("survey", "ametys:unstructured")).createChild("ametys:surveys", "ametys:unstructured");
        }
        else
        {
            surveyNode = pluginsNode.getChild("survey/ametys:surveys");
        }
        
        if (!surveyNode.hasChild(lang))
        {
            surveyNode.createChild(lang, "ametys:unstructured");
            ((JCRAmetysObject) pluginsNode).getNode().getSession().save();
        }
        
        return pluginsNode.getChild("survey/ametys:surveys/" + lang);
    }
}
