/*
 *  Copyright 2011 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.clientsideelement;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.survey.repository.Survey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.core.ui.StaticClientSideElement;

/**
 * This element creates a toggle button representing the 
 */
public class SurveyClientSideElement extends StaticClientSideElement
{
    /** The ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
    }
    
    /**
     * Get the current parameters of the survey
     * @param parameters the parameters used
     * @return the survey parameters
     */
    public Map<String, I18nizableText> getCurrentParameters(Map<String, Object> parameters)
    {
        Map<String, I18nizableText> results = new HashMap<>();
        
        String surveyId = (String) parameters.get("target");
        Survey survey = _resolver.resolveById(surveyId);
        
        boolean isValidated = survey.isValidated();
        
        results.put("validated", new I18nizableText(Boolean.toString(isValidated)));
        
        return results;
    }

}
