/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.survey.repository;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.data.type.RepositoryElementType;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;

/**
 * {@link AmetysObjectFactory} for creating {@link AbstractSurveyElement}.
 */
public class SurveyElementFactory extends DefaultTraversableAmetysObjectFactory
{
    private ModelItemTypeExtensionPoint _surveyElementDataTypeExtensionPoint;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _surveyElementDataTypeExtensionPoint = (ModelItemTypeExtensionPoint) manager.lookup(ModelItemTypeExtensionPoint.ROLE_SURVEY_ELEMENT);
    }
    
    /**
     * Retrieves the extension point holding all {@link RepositoryElementType} classes for survey elements.
     * @return the extension point holding all {@link RepositoryElementType} classes for survey elements.
     */
    public ModelItemTypeExtensionPoint getSurveyElementDataTypeExtensionPoint()
    {
        return _surveyElementDataTypeExtensionPoint;
    }
}
