/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.syndication;

import java.io.IOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.util.HttpUtils;
import org.ametys.plugins.syndication.FeedResult;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.io.CloseMode;

public class FeedCache
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable,
Disposable {
    public static final String ROLE = FeedCache.class.getName();
    protected static final String CACHE_ID = ROLE + "$feedCache";
    protected AbstractCacheManager _cacheManager;
    protected Cache<String, FeedResult> _cache;
    private CloseableHttpClient _httpClient;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        int timeoutValue = ((Long)Config.getInstance().getValue("syndication.timeout", false, (Object)2000L)).intValue();
        this._httpClient = HttpUtils.createHttpClient((int)-1, (int)timeoutValue);
        this._cacheManager.createMemoryCache(CACHE_ID, new I18nizableText("plugin.syndication", "PLUGINS_SYNDICATION_FEED_CACHE_LABEL"), new I18nizableText("plugin.syndication", "PLUGINS_SYNDICATION_FEED_CACHE_DESC"), true, Duration.ofDays(1L));
        this._cache = this._cacheManager.get(CACHE_ID);
    }

    public void preload(Collection<String> feeds) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Preloading " + feeds.size() + " feeds...");
        }
        long start = System.currentTimeMillis();
        CountDownLatch doneSignal = new CountDownLatch(feeds.size());
        for (String feed : feeds) {
            if (!this._cache.hasKey((Object)feed)) {
                new Thread(() -> {
                    try {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Preparing to load the URL '" + feed + "'");
                        }
                        long tStart = System.currentTimeMillis();
                        this._cache.get((Object)feed, u -> FeedCache.loadFeed(u, (HttpClient)this._httpClient, this.getLogger()));
                        if (this.getLogger().isDebugEnabled()) {
                            long tEnd = System.currentTimeMillis();
                            this.getLogger().debug("URL '" + feed + "' was loaded successfully in " + (tEnd - tStart) + " millis.");
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().error("An error occurred loading the URL '" + feed + "'", (Throwable)e);
                    }
                    finally {
                        doneSignal.countDown();
                    }
                }).start();
                continue;
            }
            doneSignal.countDown();
        }
        try {
            doneSignal.await();
            if (this.getLogger().isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this.getLogger().debug("Feed preloading ended in " + (end - start) + " millis.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public FeedResult getFeedNoCache(String feedUrl) throws IOException {
        return FeedCache.loadFeed(feedUrl, (HttpClient)this._httpClient, this.getLogger());
    }

    public FeedResult getFeed(String feedUrl, int lifeTime) {
        FeedResult feedResult = (FeedResult)this._cache.get((Object)feedUrl, u -> FeedCache.loadFeed(u, (HttpClient)this._httpClient, this.getLogger()));
        ZonedDateTime dateFeed = feedResult.getCreationDate();
        if (ZonedDateTime.now().isAfter(dateFeed.plusMinutes(lifeTime))) {
            this._cache.invalidate((Object)feedUrl);
            return (FeedResult)this._cache.get((Object)feedUrl, u -> FeedCache.loadFeed(u, (HttpClient)this._httpClient, this.getLogger()));
        }
        return feedResult;
    }

    protected static FeedResult loadFeed(String feedUrl, HttpClient httpClient, Logger logger) {
        FeedResult result = new FeedResult();
        result.setCreationDate(ZonedDateTime.now());
        try {
            HttpGet feedSource = new HttpGet(feedUrl);
            httpClient.execute((ClassicHttpRequest)feedSource, response -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (Exception e) {
            result.setStatus(2);
            result.setMessageError(e.getLocalizedMessage());
            logger.error("Unable to read the RSS feed to the url : " + feedUrl, (Throwable)e);
        }
        return result;
    }

    public void dispose() {
        this._httpClient.close(CloseMode.GRACEFUL);
    }
}

