/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.syndication;

import com.rometools.modules.mediarss.MediaEntryModule;
import com.rometools.modules.mediarss.types.MediaContent;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.modules.mediarss.types.Reference;
import com.rometools.modules.mediarss.types.Thumbnail;
import com.rometools.modules.mediarss.types.UrlReference;
import com.rometools.rome.feed.synd.SyndCategory;
import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEnclosure;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndImage;
import com.rometools.rome.feed.synd.SyndPerson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.syndication.FeedCache;
import org.ametys.plugins.syndication.FeedResult;
import org.ametys.runtime.config.Config;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FeedGenerator
extends ServiceableGenerator {
    protected FeedCache _feedCache;
    protected RenderingContextHandler _renderingContext;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._feedCache = (FeedCache)((Object)serviceManager.lookup(FeedCache.ROLE));
        this._renderingContext = (RenderingContextHandler)serviceManager.lookup(RenderingContextHandler.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String url;
        boolean isCustom = false;
        boolean isSelected = false;
        long length = -1L;
        String name = "";
        int lifeTime = 0;
        Map ctxParameters = (Map)this.objectModel.get("parent-context");
        if (ctxParameters != null) {
            url = (String)ctxParameters.get("url");
            name = (String)ctxParameters.get("name");
            lifeTime = (Integer)ctxParameters.get("cache");
            length = (Long)ctxParameters.get("length");
            isCustom = (Boolean)ctxParameters.get("isCustom");
            isSelected = (Boolean)ctxParameters.get("isSelected");
        } else {
            url = this.source;
        }
        this.contentHandler.startDocument();
        if (this._checkForInfiniteLoop(url)) {
            this.getLogger().error("Infinite loop detected for RSS feed : " + url + ". The RSS feed url can not be the page itself.");
            if (isCustom && this._renderingContext.getRenderingContext() == RenderingContext.FRONT) {
                this._saxErrorFeed("feed-error-custom", url, name, null);
            } else if (this._renderingContext.getRenderingContext() == RenderingContext.BACK) {
                this._saxErrorFeed("feed-error", url, name, "Infinite loop detected for RSS feed : " + url + ". The RSS feed url can not be the page itself.");
            }
        } else {
            FeedResult feedResult = this._feedCache.getFeed(url, lifeTime);
            if (feedResult.getStatus() == 1) {
                SyndFeed feed = feedResult.getSynFeed();
                this._saxFeeds(feed, length, url, isCustom, isSelected);
            } else if (this._renderingContext.getRenderingContext() == RenderingContext.BACK) {
                this._saxErrorFeed("feed-error", url, name, feedResult.getMessageError());
            } else if (isCustom && this._renderingContext.getRenderingContext() == RenderingContext.FRONT) {
                this._saxErrorFeed("feed-error-custom", url, name, null);
            }
        }
        this.contentHandler.endDocument();
    }

    private void _saxErrorFeed(String errorName, String url, String name, String messageError) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this._addAttribute(atts, "url", url);
        this._addAttribute(atts, "name", name);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)messageError)) {
            this._addAttribute(atts, "messageError", messageError);
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)errorName, (Attributes)atts);
    }

    private void _saxFeeds(SyndFeed feed, long length, String url, Boolean isCustom, Boolean isSelected) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this._addAttribute(atts, "title", feed.getTitle());
        this._addAttribute(atts, "description", feed.getDescription());
        this._addAttribute(atts, "feedUrl", url);
        this._addAttribute(atts, "isCustom", String.valueOf(isCustom));
        this._addAttribute(atts, "isSelected", String.valueOf(isSelected));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"feed", (Attributes)atts);
        SyndImage image = feed.getImage();
        if (image != null) {
            atts = new AttributesImpl();
            this._addAttribute(atts, "link", image.getLink());
            this._addAttribute(atts, "url", image.getUrl());
            this._addAttribute(atts, "title", image.getTitle());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"image", (Attributes)atts);
        }
        List feedCategories = feed.getCategories();
        this._saxCategories(feedCategories);
        List entries = feed.getEntries();
        if (entries != null) {
            int index = 0;
            Iterator it = entries.iterator();
            while (it.hasNext() && (length == -1L || (long)index < length)) {
                List authors;
                SyndEntry entry = (SyndEntry)it.next();
                atts = new AttributesImpl();
                this._addAttribute(atts, "title", entry.getTitle());
                this._addAttribute(atts, "link", entry.getLink());
                Date date = entry.getPublishedDate();
                if (date != null) {
                    this._addAttribute(atts, "date", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm").format(date));
                }
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"entry", (Attributes)atts);
                SyndContent desc = entry.getDescription();
                if (desc != null && desc.getValue() != null) {
                    atts = new AttributesImpl();
                    this._addAttribute(atts, "type", desc.getType());
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (Attributes)atts, (String)desc.getValue());
                }
                if ((authors = entry.getAuthors()) != null) {
                    for (SyndPerson author : authors) {
                        atts = new AttributesImpl();
                        this._addAttribute(atts, "email", author.getEmail());
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"author", (Attributes)atts, (String)author.getName());
                    }
                }
                this._saxEnclosures(entry);
                List entryCategories = entry.getCategories();
                this._saxCategories(entryCategories);
                this._saxMediaRSS(entry);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"entry");
                ++index;
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"feed");
    }

    private void _saxCategories(List<SyndCategory> feedCategories) throws SAXException {
        for (SyndCategory category : feedCategories) {
            AttributesImpl categoryAtts = new AttributesImpl();
            String taxonomyUri = category.getTaxonomyUri();
            if (taxonomyUri != null) {
                this._addAttribute(categoryAtts, "domain", taxonomyUri);
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"category", (Attributes)categoryAtts, (String)category.getName());
        }
    }

    private void _saxEnclosures(SyndEntry entry) throws SAXException {
        List enclosures = entry.getEnclosures();
        if (enclosures != null) {
            for (SyndEnclosure enclosure : enclosures) {
                AttributesImpl atts = new AttributesImpl();
                this._addAttribute(atts, "type", enclosure.getType());
                this._addAttribute(atts, "url", enclosure.getUrl());
                this._addAttribute(atts, "name", this._enclosureName(enclosure.getUrl()));
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"enclosure", (Attributes)atts);
                this._saxLength(enclosure.getLength());
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"enclosure");
            }
        }
    }

    private void _saxMediaRSS(SyndEntry entry) throws SAXException {
        MediaEntryModule module = (MediaEntryModule)entry.getModule("http://search.yahoo.com/mrss/");
        if (module != null) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"media");
            for (MediaContent mediaContent : module.getMediaContents()) {
                this._saxMediaContent(mediaContent, false);
            }
            for (MediaContent mediaContent : module.getMediaGroups()) {
                AttributesImpl atts = new AttributesImpl();
                this._addAttribute(atts, "defaultContentIndex", mediaContent.getDefaultContentIndex());
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"mediagroup", (Attributes)atts);
                for (MediaContent content : mediaContent.getContents()) {
                    this._saxMediaContent(content, true);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"mediagroup");
            }
            Metadata metadata = module.getMetadata();
            if (metadata != null) {
                this.saxMediaMetadata(metadata);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"media");
        }
    }

    private void _saxMediaContent(MediaContent content, boolean inGroup) throws SAXException {
        Metadata metadata = content.getMetadata();
        Reference reference = content.getReference();
        AttributesImpl atts = new AttributesImpl();
        if (reference instanceof UrlReference) {
            this._addAttribute(atts, "url", ((UrlReference)reference).getUrl().toString());
        }
        if (inGroup && content.isDefaultContent()) {
            atts.addCDATAAttribute("default", "true");
        }
        this._addAttribute(atts, "type", content.getType());
        this._addAttribute(atts, "medium", content.getMedium());
        this._addAttribute(atts, "size", content.getFileSize());
        this._addAttribute(atts, "width", content.getWidth());
        this._addAttribute(atts, "height", content.getHeight());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"mediacontent", (Attributes)atts);
        if (metadata != null) {
            this.saxMediaMetadata(metadata);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"mediacontent");
    }

    private void saxMediaMetadata(Metadata metadata) throws SAXException {
        if (metadata != null) {
            String title = metadata.getTitle();
            Thumbnail[] thumbnails = metadata.getThumbnail();
            if (title != null) {
                AttributesImpl titleAttrs = new AttributesImpl();
                this._addAttribute(titleAttrs, "type", metadata.getTitleType());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (Attributes)titleAttrs, (String)title);
            }
            for (Thumbnail thumbnail : thumbnails) {
                AttributesImpl thumbAttrs = new AttributesImpl();
                this._addAttribute(thumbAttrs, "url", thumbnail.getUrl().toString());
                this._addAttribute(thumbAttrs, "width", thumbnail.getWidth());
                this._addAttribute(thumbAttrs, "height", thumbnail.getHeight());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"thumbnail", (Attributes)thumbAttrs);
            }
        }
    }

    private boolean _checkForInfiniteLoop(String src) {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        Page page = (Page)request.getAttribute(Page.class.getName());
        if (page == null) {
            return false;
        }
        String cmsUrl = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("cms.url")));
        Site site = page.getSite();
        String siteName = page.getSiteName();
        String lang = page.getSitemapName();
        String path = page.getPathInSitemap();
        String frontUrl = site.getUrl() + "/" + lang + "/" + path + ".html";
        if (src.equals(frontUrl)) {
            return true;
        }
        String previewUrl = cmsUrl + "/preview/" + siteName + "/" + lang + "/" + path + ".html";
        if (src.equals(previewUrl)) {
            return true;
        }
        String liveUrl = cmsUrl + "/live/" + siteName + "/" + lang + "/" + path + ".html";
        if (src.equals(liveUrl)) {
            return true;
        }
        String backUrl = cmsUrl + siteName + "/" + lang + "/" + path + ".html";
        return src.equals(backUrl);
    }

    private String _enclosureName(String url) {
        String name = url;
        if (name != null && name.lastIndexOf("/") > 0) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        if (name != null && name.indexOf("?") > 0) {
            name = name.substring(0, name.indexOf("?"));
        }
        return name;
    }

    private void _addAttribute(AttributesImpl atts, String name, Object value) {
        if (value != null) {
            if (value instanceof String) {
                atts.addCDATAAttribute(name, (String)value);
            } else if (value instanceof Integer) {
                atts.addCDATAAttribute(name, ((Integer)value).toString());
            } else if (value instanceof Long) {
                atts.addCDATAAttribute(name, ((Long)value).toString());
            } else if (value instanceof Double) {
                atts.addCDATAAttribute(name, ((Double)value).toString());
            } else if (value instanceof Float) {
                atts.addCDATAAttribute(name, ((Float)value).toString());
            }
        }
    }

    private void _saxLength(long length) throws SAXException {
        StringUtils.toReadableDataSize((Long)length).toSAX(this.contentHandler, "length");
    }
}

