/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.syndication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.syndication.FeedCache;
import org.ametys.plugins.syndication.RssFeedUserPrefsComponent;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FeedsGenerator
extends ServiceableGenerator {
    public static final String USER_PREF_RSS_URL_KEY = "user-pref-rss-urls";
    public static final String USER_PREF_RSS_ID_KEY = "user-pref-rss-positions";
    private static HashMap<String, Integer> _lifeTimes = new HashMap();
    protected RssFeedUserPrefsComponent _confAccess;
    protected RightManager _rightManager;
    protected GroupManager _groupManager;
    protected FeedCache _feedCache;
    protected SourceResolver _resolver;
    protected UserPreferencesManager _userPrefManager;
    protected RenderingContextHandler _renderingContext;
    protected CurrentUserProvider _currentUserProvider;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._feedCache = (FeedCache)((Object)serviceManager.lookup(FeedCache.ROLE));
        this._rightManager = (RightManager)this.manager.lookup(RightManager.ROLE);
        this._groupManager = (GroupManager)serviceManager.lookup(GroupManager.ROLE);
        this._userPrefManager = (UserPreferencesManager)serviceManager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._renderingContext = (RenderingContextHandler)serviceManager.lookup(RenderingContextHandler.ROLE);
        this._confAccess = (RssFeedUserPrefsComponent)serviceManager.lookup(RssFeedUserPrefsComponent.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        UserIdentity user = this._currentUserProvider.getUser();
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        String siteName = sitemapElement.getSiteName();
        String lang = sitemapElement.getSitemapName();
        String storageContext = siteName + "/" + lang + "/" + zoneItem.getId();
        Map<String, String> contextVars = this._getContextVars(siteName, lang);
        ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
        ArrayList<String> urlList = new ArrayList();
        List<String> idList = new ArrayList<String>();
        try {
            if (!this._rightManager.hasAnonymousReadAccess((Object)sitemapElement)) {
                urlList = this._getListUrl(user, storageContext, contextVars);
                idList = this._getListId(user, storageContext, contextVars);
            }
        }
        catch (UserPreferencesException e1) {
            this.getLogger().error("Can't have the user preference from user : '" + String.valueOf(user) + "'");
        }
        this.contentHandler.startDocument();
        this._saxAllFeed(request, zoneItem, serviceParameters, urlList, idList);
        this.contentHandler.endDocument();
    }

    private void _saxAllFeed(Request request, ZoneItem zoneItem, ModelAwareDataHolder serviceParameters, List<String> urlList, List<String> userSelectedFeedsId) throws SAXException {
        long defaultLength = (Long)serviceParameters.getValue("length", false, (Object)-1L);
        String defaultLifeTime = (String)serviceParameters.getValue("cache");
        AttributesImpl atts = new AttributesImpl();
        ModelAwareRepeater rssFeeds = serviceParameters.getRepeater("feeds");
        List<ModelAwareRepeaterEntry> listFeeds = rssFeeds.getEntries().stream().filter(entry -> this._checkUserAccessRSS((ModelAwareRepeaterEntry)entry)).collect(Collectors.toList());
        int nbMaxFeedFullSaxed = Math.toIntExact((Long)serviceParameters.getValue("nb-feed-max", false, (Object)0L));
        int nbMaxUser = Math.toIntExact((Long)serviceParameters.getValue("nb-feed-user", false, (Object)0L));
        atts.addCDATAAttribute("nbFeedService", String.valueOf(listFeeds.size()));
        atts.addCDATAAttribute("zoneItemId", String.valueOf(zoneItem.getId()));
        atts.addCDATAAttribute("nbMaxUser", String.valueOf(nbMaxUser));
        atts.addCDATAAttribute("nbMax", String.valueOf(nbMaxFeedFullSaxed));
        Page page = (Page)request.getAttribute(Page.class.getName());
        atts.addCDATAAttribute("showForm", String.valueOf(this._confAccess.showPreferenceForm(page, nbMaxUser, listFeeds.size(), nbMaxFeedFullSaxed)));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"rssFeeds", (Attributes)atts);
        this._saxFeeds(nbMaxUser, listFeeds, urlList, nbMaxFeedFullSaxed, defaultLength, defaultLifeTime, serviceParameters, userSelectedFeedsId);
        this._saxFeedsConfig(nbMaxUser, listFeeds, urlList, userSelectedFeedsId);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"rssFeeds");
    }

    private void _saxFeedsConfig(long nbMaxUser, List<ModelAwareRepeaterEntry> listFeeds, List<String> urlList, List<String> userSelectedFeedsId) throws SAXException {
        for (ModelAwareRepeaterEntry rssFeed : listFeeds) {
            this._saxInfoFeed((String)rssFeed.getValue("url"), (String)rssFeed.getValue("title"), (String)rssFeed.getValue("id"), false, userSelectedFeedsId.contains(rssFeed.getValue("id")));
        }
        int i = 1;
        while ((long)i <= nbMaxUser) {
            boolean isSelected;
            boolean bl = isSelected = userSelectedFeedsId.contains("feed-url" + i) || userSelectedFeedsId.contains(String.valueOf(i + listFeeds.size()));
            if (i <= urlList.size()) {
                String url = urlList.get(i - 1);
                this._saxInfoFeed(url, "", "feed-url" + i, true, isSelected);
            } else {
                this._saxInfoFeed("", "", "feed-url" + i, true, isSelected);
            }
            ++i;
        }
    }

    private void _saxFeeds(int nbMaxUser, List<ModelAwareRepeaterEntry> listFeeds, List<String> urlList, long nbMaxFeedFullSaxed, long defaultLength, String defaultLifeTime, ModelAwareDataHolder serviceParameters, List<String> userSelectedFeedsId) {
        boolean isSelected;
        int nbFeedFullSaxed = 0;
        for (ModelAwareRepeaterEntry rssFeed : listFeeds) {
            isSelected = userSelectedFeedsId.contains(rssFeed.getValue("id"));
            if ((long)nbFeedFullSaxed >= nbMaxFeedFullSaxed && nbMaxFeedFullSaxed != 0L || !userSelectedFeedsId.isEmpty() && !isSelected) continue;
            ++nbFeedFullSaxed;
            this._saxFullInfoFeed(rssFeed, isSelected, defaultLength, defaultLifeTime);
        }
        for (int i = 1; i <= nbMaxUser; ++i) {
            if (i > urlList.size()) continue;
            String url = urlList.get(i - 1);
            boolean bl = isSelected = userSelectedFeedsId.contains("feed-url" + i) || userSelectedFeedsId.contains(String.valueOf(i + listFeeds.size()));
            if ((long)nbFeedFullSaxed >= nbMaxFeedFullSaxed && nbMaxFeedFullSaxed != 0L || !userSelectedFeedsId.isEmpty() && !isSelected) continue;
            ++nbFeedFullSaxed;
            this._saxFullInfoFeedCustom(serviceParameters, url, defaultLength, isSelected);
        }
    }

    private void _saxInfoFeed(String url, String name, String feedId, boolean isCustom, boolean isSelected) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("feedUrl", url);
        atts.addCDATAAttribute("feedName", name);
        atts.addCDATAAttribute("feedId", feedId);
        atts.addCDATAAttribute("isCustom", String.valueOf(isCustom));
        atts.addCDATAAttribute("isSelected", String.valueOf(isSelected));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"feed-conf", (Attributes)atts);
    }

    private void _saxFullInfoFeed(ModelAwareRepeaterEntry rssFeed, boolean isSelected, long defaultLength, String defaultLifeTime) {
        long nbItems = (Long)rssFeed.getValue("length", false, (Object)defaultLength);
        String lifeTime = (String)rssFeed.getValue("cache");
        if (StringUtils.isBlank((CharSequence)lifeTime)) {
            lifeTime = defaultLifeTime;
        }
        String url = (String)rssFeed.getValue("url");
        String name = (String)rssFeed.getValue("title");
        this._saxFeed(nbItems, url, name, lifeTime, false, isSelected);
    }

    private void _saxFullInfoFeedCustom(ModelAwareDataHolder serviceParameters, String url, long defaultLength, boolean isSelected) {
        String lifeTime = (String)serviceParameters.getValue("cache");
        this._saxFeed(defaultLength, url, "", lifeTime, true, isSelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saxFeed(long length, String url, String name, String lifeTime, Boolean isCustom, Boolean isSelected) {
        SitemapSource sitemapSource = null;
        try {
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("length", length);
            parameter.put("url", url);
            parameter.put("name", name);
            parameter.put("cache", _lifeTimes.get(lifeTime));
            parameter.put("isCustom", isCustom);
            parameter.put("isSelected", isSelected);
            sitemapSource = (SitemapSource)this._resolver.resolveURI("cocoon:/feed", null, parameter);
            sitemapSource.toSAX((ContentHandler)new IgnoreRootHandler(this.contentHandler));
            this._resolver.release((Source)sitemapSource);
        }
        catch (Exception e) {
            this.getLogger().error("There is an error in the flux : '" + url + "'");
        }
        finally {
            this._resolver.release(sitemapSource);
        }
    }

    private List<String> _getListUrl(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        if (user != null) {
            String urls = this._userPrefManager.getUserPreferenceAsString(user, storageContext, contextVars, USER_PREF_RSS_URL_KEY);
            ArrayList<String> urlAsList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)urls)) {
                String[] urlsAsArray;
                for (String url : urlsAsArray = StringUtils.split((String)urls, (String)",")) {
                    urlAsList.add(URIUtils.decode((String)url));
                }
            }
            return urlAsList;
        }
        return new ArrayList<String>();
    }

    private List<String> _getListId(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        String ids;
        if (user != null && StringUtils.isNotEmpty((CharSequence)(ids = this._userPrefManager.getUserPreferenceAsString(user, storageContext, contextVars, USER_PREF_RSS_ID_KEY)))) {
            String[] positionsAsArray = ids.split(",");
            return Arrays.asList(positionsAsArray);
        }
        return new ArrayList<String>();
    }

    private boolean _checkUserAccessRSS(ModelAwareRepeaterEntry rssFeed) {
        UserIdentity user = this._currentUserProvider.getUser();
        Boolean limited = (Boolean)rssFeed.getValue("limited");
        if (limited.booleanValue()) {
            return user != null;
        }
        String[] foGroupsStr = (String[])rssFeed.getValue("fo-group", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY);
        Set foGroups = Arrays.asList(foGroupsStr).stream().filter(identityAsStr -> identityAsStr.length() > 0).map(identityAsStr -> this._jsonUtils.convertJsonToMap(identityAsStr)).map(identityAsMap -> new GroupIdentity((String)identityAsMap.get("groupId"), (String)identityAsMap.get("groupDirectory"))).collect(Collectors.toSet());
        UserIdentity[] foUsersArray = (UserIdentity[])rssFeed.getValue("fo-user", false, (Object)new UserIdentity[0]);
        Set foUsers = Arrays.asList(foUsersArray).stream().collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(foUsers) && CollectionUtils.isEmpty(foGroups)) {
            return true;
        }
        if (user == null) {
            return false;
        }
        if (foUsers.contains(user)) {
            return true;
        }
        for (GroupIdentity foGroup : foGroups) {
            Group group;
            if (foGroup == null || (group = this._groupManager.getGroup(foGroup)) == null || !group.getUsers().contains(user)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> _getContextVars(String siteName, String language) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        contextVars.put("sitemapLanguage", language);
        return contextVars;
    }

    static {
        _lifeTimes.put("1", 1440);
        _lifeTimes.put("2", 180);
        _lifeTimes.put("3", 30);
    }
}

