/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.syndication;

import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;

public class RssFeedUserPrefsComponent
implements Component,
Serviceable {
    public static final String ROLE = RssFeedUserPrefsComponent.class.getName();
    protected RightManager _rightManager;
    protected RenderingContextHandler _renderingContext;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._renderingContext = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public boolean showPreferenceForm(Page page, int nbCustomFeeds, long nbFeeds, long maxFeeds) {
        if (page == null) {
            return false;
        }
        return !this._rightManager.hasAnonymousReadAccess((Object)page) && this._hasCustomsFeeds(nbCustomFeeds, nbFeeds, maxFeeds);
    }

    public boolean isServiceCacheable(ModelAwareRepeater repeater, int nbCustomFeeds, int nbFeeds, int maxFeeds) {
        for (ModelAwareRepeaterEntry feed : repeater.getEntries()) {
            boolean limited = (Boolean)feed.getValue("limited");
            Object[] foUsers = (UserIdentity[])feed.getValue("fo-user", false, (Object)new UserIdentity[0]);
            Object[] foGroups = (String[])feed.getValue("fo-group", false, (Object)ArrayUtils.EMPTY_STRING_ARRAY);
            if (!limited && !ArrayUtils.isNotEmpty((Object[])foUsers) && !ArrayUtils.isNotEmpty((Object[])foGroups)) continue;
            return false;
        }
        return !this._hasCustomsFeeds(nbCustomFeeds, nbFeeds, maxFeeds);
    }

    private boolean _hasCustomsFeeds(int nbCustomFeeds, long nbFeeds, long maxFeeds) {
        if (nbCustomFeeds != 0) {
            return true;
        }
        return maxFeeds != 0L && maxFeeds < nbFeeds;
    }
}

