/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.syndication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class SetRssFeedUserPreferencesAction
extends ServiceableAction {
    protected UserPreferencesManager _userPrefManager;
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userPrefManager = (UserPreferencesManager)serviceManager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        UserIdentity user = this._currentUserProvider.getUser();
        String zoneItemId = request.getParameter("zone-item-id");
        ZoneItem zoneItem = (ZoneItem)this._resolver.resolveById(zoneItemId);
        SitemapElement sitemapElement = zoneItem.getZone().getSitemapElement();
        String language = sitemapElement.getSitemapName();
        String siteName = sitemapElement.getSiteName();
        String storageContext = siteName + "/" + language + "/" + zoneItem.getId();
        Map<String, String> contextVars = this._getContextVars(siteName, language);
        HashMap<String, String> values = new HashMap<String, String>();
        String ids = this._getIds(request);
        int nbMaxCheck = Integer.parseInt(request.getParameter("nbMaxCheck"));
        if (StringUtils.split((String)ids, (String)",").length <= nbMaxCheck || nbMaxCheck == 0) {
            values.put("user-pref-rss-positions", ids);
            values.put("user-pref-rss-urls", this._getUrls(request));
            this._userPrefManager.setUserPreferences(user, storageContext, contextVars, values);
        } else {
            errors.add(new I18nizableText("plugin.syndication", "SYNDICATION_SERVICE_CONFIG_RSS_ERROR_TO_MANY_CHECK"));
        }
        if (errors.size() > 0) {
            result.put("error", errors);
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    private String _getUrls(Request request) {
        int nbFeedUser = Integer.parseInt(request.getParameter("nbMaxUser"));
        int nbFeed = Integer.parseInt(request.getParameter("nbFeedService"));
        int position = nbFeed + 1;
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < nbFeedUser; ++i) {
            String url = request.getParameter("feed-url-" + (position + i));
            if (StringUtils.isWhitespace((CharSequence)url)) continue;
            urls.add(URIUtils.encodePath((String)url));
        }
        return StringUtils.join(urls, (String)",");
    }

    private String _getIds(Request request) {
        int nbFeed = Integer.parseInt(request.getParameter("nbFeedService"));
        int nbFeedUser = Integer.parseInt(request.getParameter("nbMaxUser"));
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 1; i <= nbFeed + nbFeedUser; ++i) {
            String url;
            String checked = request.getParameter("feed-check-" + i);
            if (StringUtils.isEmpty((CharSequence)checked) || !checked.equals("true") && !checked.equals("on") || StringUtils.isWhitespace((CharSequence)(url = request.getParameter("feed-url-" + i)))) continue;
            ids.add(request.getParameter("feed-id-" + i));
        }
        return StringUtils.join(ids, (String)",");
    }

    private Map<String, String> _getContextVars(String siteName, String language) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        contextVars.put("sitemapLanguage", language);
        return contextVars;
    }
}

