<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                extension-element-prefixes="math ametys resolver">

    <xsl:variable name="uniqueId" select="concat('feed_', substring-after(math:random(), '.'))"/>
    <xsl:variable name="link" select="ametys:serviceParameter('link')/text()"/>
    <xsl:variable name="link-title" select="ametys:serviceParameter('link-title')/text()"/>
    
    <!-- Template for display error on a custom feed --> 
    <xsl:template name="feed-error-custom"> 
        <li>
            <p><i18n:text i18n:key="SYNDICATION_SERVICE_XSL_ERROR_FEED_CUSTOM" i18n:catalogue="plugin.syndication"/><xsl:value-of select="@url" /></p>
        </li>
    </xsl:template>        
     
    <!-- Template for BO error only -->
    <xsl:template name="feed-error">
        <div class="ametys-cms-zone-error syndication-feed-error">
            <div class="ametys-cms-zone-item-error">
                <table cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr>
                            <td style="vertical-align: top; width: 36px;">
                                <img alt="error" src="{ametys:pluginResourceURL('web', '/img/skin/zoneitem_error_32.png')}" />
                            </td>
                            <td>
                                <strong><i18n:text i18n:key="SYNDICATION_SERVICE_XSL_ERROR_FEED_LABEL" i18n:catalogue="plugin.syndication" /></strong>
                                <br />
                                <em>
                                    <i18n:text i18n:key="SYNDICATION_SERVICE_XSL_ERROR_FEED" i18n:catalogue="plugin.syndication" />
                                    <br />
                                    <xsl:if test="@name != ''">
                                        <xsl:value-of select="@name" /><xsl:text> - </xsl:text>
                                    </xsl:if>
                                    <xsl:value-of select="@url" />
                                </em>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <xsl:if test="@messageError != ''">
                    <div class="exception-message">
                        <xsl:value-of select="@messageError" />
                    </div>
                </xsl:if>
            </div>
        </div>
    </xsl:template>   
            
    <!-- Template used to display link "all contents" on the top -->
    <xsl:template name="link-top">
        <xsl:call-template name="link"/>
    </xsl:template>

    <!-- Template used to display link "all contents" on the bottom -->
    <xsl:template name="link-bottom">
        <xsl:comment>empty</xsl:comment>
    </xsl:template>
    
    <!-- Template used for link "all contents" -->
    <xsl:template name="link">
        <xsl:if test="starts-with($link, 'page://')">
            <div class="link">
                <a href="{resolver:resolve('page', $link)}">
                    <xsl:choose>
                        <xsl:when test="normalize-space($link-title) != ''">
                            <xsl:value-of select="$link-title"/>
                        </xsl:when>
                        <xsl:otherwise><i18n:text i18n:key="PLUGINS_WEB_SERVICE_FILTERED_CONTENTS_LINK_TITLE_DEFAULT" i18n:catalogue="plugin.web"/></xsl:otherwise>
                    </xsl:choose>
                </a>
            </div>
        </xsl:if>    
    </xsl:template>
    
    <!-- Title of RSS entry -->
    <xsl:template name="item-title">
   	   <h2 class="rss-title">
           <xsl:choose>
               <xsl:when test="@link">
                   <a href="{@link}"><xsl:value-of select="@title"/></a>
               </xsl:when>
               <xsl:otherwise>
               	<xsl:value-of select="@title"/></xsl:otherwise>
           </xsl:choose>
   	   </h2>
    </xsl:template>
    
    <!-- Date of RSS entry -->
    <xsl:template name="item-date">    
        <xsl:if test="@date">
            <p class="date">
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm" pattern="medium"><xsl:value-of select="@date"/></i18n:date>
                <xsl:text> </xsl:text>
                <i18n:time src-pattern="yyyy-MM-dd'T'HH:mm" pattern="short"><xsl:value-of select="@date"/></i18n:time>
            </p>
        </xsl:if>
    </xsl:template>

    <!-- Image of RSS entry -->
    <xsl:template match="image"> 
        <p class="image">
            <a href="{@link}">
                <img src="{@url}" alt="{@title}">
                    <xsl:if test="heigth"><xsl:attribute name="height"><xsl:value-of select="height"/></xsl:attribute></xsl:if>
                    <xsl:if test="width"><xsl:attribute name="width"><xsl:value-of select="width"/></xsl:attribute></xsl:if>
                </img>
            </a>
        </p>
    </xsl:template>

    <!-- Description of RSS entry -->
    <xsl:template name="item-description">  
        <xsl:if test="description">
            <p class="description">
                <xsl:choose>
                    <xsl:when test="'text/html'">
                        <xsl:value-of select="description" disable-output-escaping="yes"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="description"/>
                    </xsl:otherwise>
                </xsl:choose>
            </p>
        </xsl:if>    
    </xsl:template>    
    
    <!-- Attachments of RSS entry --> 
    <xsl:template name="item-attachments">
        <xsl:if test="enclosure">
            <div class="enclosures">
                <xsl:for-each select="enclosure[@url]">
                    <div class="enclosure">
                        <xsl:choose>
                            <xsl:when test="starts-with(@type, 'video')"><xsl:attribute name="class">enclosure video</xsl:attribute></xsl:when>
                            <xsl:when test="starts-with(@type, 'audio')"><xsl:attribute name="class">enclosure audio</xsl:attribute></xsl:when>
                            <xsl:when test="starts-with(@type, 'image')"><xsl:attribute name="class">enclosure image</xsl:attribute></xsl:when>
                        </xsl:choose>
                        <a href="{@url}">
                            <xsl:choose>
                                <xsl:when test="@name"><xsl:value-of select="@name"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
                            </xsl:choose>
                        </a>
                        <xsl:if test="length">
                            <span class="length"> (<xsl:value-of select="length"/>)</span>
                        </xsl:if>
                    </div>
                </xsl:for-each>
            </div>
        </xsl:if>    
    </xsl:template>    
    
    <!-- Author of RSS entry --> 
    <xsl:template name="item-author">
        <!-- Item author(s) -->
        <xsl:if test="author">
            <p class="feed-entry-author">
                <i18n:text i18n:key="FEED_ENTRY_AUTHOR"/>
                <xsl:for-each select="author">
                    <xsl:choose>
                        <xsl:when test="@email">
                            <a href="mailto:{@email}"><xsl:value-of select="."/></a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="."/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="position () != last()">, </xsl:if>
                </xsl:for-each>
            </p>
        </xsl:if>    
    </xsl:template>
    
</xsl:stylesheet>
