<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:param name="header" select="ametys:serviceParameter('header')/text()"/>

	<xsl:template match="/rssFeeds">
		<html>
			<head>
				<!-- CSS -->
				<link href="{ametys:pluginResourceURL('syndication', 'css/service-feed.css')}" rel="stylesheet" type="text/css" />
			    <xsl:if test="ametys:renderingContext() = 'back'">
    			    <link href="{ametys:pluginResourceURL('syndication', 'css/bo-error.css')}" rel="stylesheet" type="text/css" />
			    </xsl:if>
            </head>
			
			<body>
				<xsl:if test="$header != ''"><h3><xsl:value-of select="$header"/></h3></xsl:if>
			
				<div class="feed-wrapper">
					<xsl:for-each select="feed">
						
						<xsl:apply-templates select="image"/>
						
						<h1><xsl:value-of select="@title"/></h1>
						<h2><xsl:value-of select="@description"/></h2>
						
						<!-- 
						<xsl:if test="link">
							<a class="rss-link" href="{link}" title="{title}"><xsl:value-of select="link"></xsl:value-of></a>
						</xsl:if>
						 -->
						 
						 <!-- 
						<xsl:if test="lastBuildDate">
							<div class="rss-date"><xsl:value-of select="lastBuildDate"/></div>
						</xsl:if>
						-->
						 
						<div class="feed-entry-list">
							<xsl:apply-templates select="entry"/>
						</div>
					</xsl:for-each>
					
				</div>
			</body>
			
		</html>
	</xsl:template>
	
	<xsl:template match="image"> 
		<div class="feed-image">
			<a href="{@link}" title="{@title}">
				<img src="{@url}" alt="{@title}">
					<xsl:if test="heigth"><xsl:attribute name="height"><xsl:value-of select="height"/></xsl:attribute></xsl:if>
					<xsl:if test="width"><xsl:attribute name="width"><xsl:value-of select="width"/></xsl:attribute></xsl:if>
				</img>
			</a>
		</div>
	</xsl:template>
	
	<xsl:template match="entry"> 
		<div class="feed-entry">
			
			<!-- Item title -->
			<div class="feed-entry-title">
				<xsl:choose>
					<xsl:when test="@link">
						<a href="{@link}" title="{@title}"><xsl:value-of select="@title"/></a>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
				</xsl:choose>
			</div>
			
			<!-- Item publication date -->
			<xsl:if test="@date">
				<div class="feed-entry-date"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm" pattern="medium"><xsl:value-of select="@date"/></i18n:date><xsl:text> </xsl:text><i18n:time src-pattern="yyyy-MM-dd'T'HH:mm" pattern="short"><xsl:value-of select="@date"/></i18n:time></div>
			</xsl:if>
			
            <xsl:apply-templates select="image"/>
			
			<!-- Item description -->
			<xsl:if test="description">
				<div class="feed-entry-description">
                    <xsl:choose>
                        <xsl:when test="'text/html'">
                            <xsl:value-of select="description" disable-output-escaping="yes"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="description"/>
                        </xsl:otherwise>
                    </xsl:choose>
				</div>
			</xsl:if>
            
            <!-- Item attachments -->
            <xsl:if test="enclosure">
            	<div class="feed-entry-enclosures">
            		<xsl:for-each select="enclosure[@url]">
	                    <xsl:if test="@url">
	                    	<div class="enclosure">
	                    		<xsl:choose>
	                    			<xsl:when test="starts-with(@type, 'video')"><xsl:attribute name="class">enclosure video</xsl:attribute></xsl:when>
	                    			<xsl:when test="starts-with(@type, 'audio')"><xsl:attribute name="class">enclosure audio</xsl:attribute></xsl:when>
	                    			<xsl:when test="starts-with(@type, 'image')"><xsl:attribute name="class">enclosure image</xsl:attribute></xsl:when>
	                    		</xsl:choose>
	                        	<a href="{@url}">
	                        		<xsl:choose>
	                        			<xsl:when test="@name"><xsl:value-of select="@name"/></xsl:when>
	                        			<xsl:otherwise><xsl:value-of select="@url"/></xsl:otherwise>
	                        		</xsl:choose>
	                        	</a>
	                        	<xsl:if test="length">
	                        		<span class="length"> (<xsl:value-of select="length"/>)</span>
	                        	</xsl:if>
	                        </div>
	                    </xsl:if>
                    </xsl:for-each>
                </div>
            </xsl:if>
            
            <!-- Item author(s) -->
			<xsl:if test="author">
				<div class="feed-entry-author">
					<i18n:text i18n:key="FEED_ENTRY_AUTHOR"/>
					<xsl:for-each select="author">
						<xsl:choose>
							<xsl:when test="@email">
								<a href="mailto:{@email}"><xsl:value-of select="."/></a>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="position () != last()">, </xsl:if>
					</xsl:for-each>
				</div>
			</xsl:if>
		</div>
	</xsl:template>
</xsl:stylesheet>
