<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                extension-element-prefixes="math ametys resolver">

    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:syndication://pages/services/feed/common.xsl"/>
    <xsl:import href="service:syndication://pages/services/feed/utils/preference.xsl"/>
    
	<xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>

    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">syndication syndication-by-date</xsl:variable>
    <xsl:variable name="is-empty" select="not(/rssFeeds/feed) and not(/rssFeeds/feed-conf) and not(/rssFeeds/feed-error) and not(/rssFeeds/feed-error-custom)"/>
    <xsl:variable name="common-service-name">service-syndication</xsl:variable>    


    <xsl:variable name="raw-is-title-visible">        
    	<xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:variable>    
    <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
    
  <!-- +
         | HEAD
         + -->

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:template> 

    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <xsl:if test="ametys:renderingContext() = 'back'">
            <link href="{ametys:pluginResourceURL('syndication', 'css/bo-error.css')}" rel="stylesheet" type="text/css" />
        </xsl:if>    
    </xsl:template> 
      
    <!-- +
         | BODY
         + -->    

    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <!-- Link to edit user RSS feed preferences -->
        <xsl:call-template name="feed-config-link"/>
        
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="link-top"/>        
        <div>
            <!-- Handle my RSS feed form -->
            <xsl:call-template name="feed-config-form" />
            
           <!-- Errors on customs feed -->
            <xsl:if test="/rssFeeds/feed-error-custom">
                <div class="error">
                    <ul>
                        <xsl:for-each select="/rssFeeds/feed-error-custom">
                           <xsl:call-template name="feed-error-custom" />
                        </xsl:for-each>
                    </ul>
                </div>
            </xsl:if>
            
            <!-- Errors on feed (BO mode only) -->
            <xsl:if test="/rssFeeds/feed-error">
                <div>
                    <xsl:for-each select="/rssFeeds/feed-error">
                       <xsl:call-template name="feed-error" />
                    </xsl:for-each>        
                </div>
            </xsl:if>
            
            <!-- RSS entries -->
            <xsl:if test="/rssFeeds/feed/entry">
                <ul class="feed-list">
    		        <xsl:for-each select="/rssFeeds/feed/entry">
    		            <xsl:sort select="@date" order="descending"/>
    			        <xsl:call-template name="entry"/>
    		        </xsl:for-each>
    	        </ul>
            </xsl:if>
        </div>
        <xsl:call-template name="link-bottom"/>        
    </xsl:template>    
            
    <!-- Template for each item -->    
	<xsl:template name="entry"> 
		<li>
            <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
            
            <xsl:apply-templates select="image"/>
            <xsl:call-template name="item-title"/>
            <xsl:call-template name="item-date"/>
            <xsl:call-template name="item-description"/>
            <xsl:call-template name="item-attachments"/>
            <xsl:call-template name="item-author"/>
		</li>
	</xsl:template>

    <!-- Date of RSS entry -->
    <xsl:template name="item-date">    
        <p class="date">
            <xsl:if test="@date">
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm" pattern="medium"><xsl:value-of select="@date"/></i18n:date>
                <xsl:text> </xsl:text>
                <i18n:time src-pattern="yyyy-MM-dd'T'HH:mm" pattern="short"><xsl:value-of select="@date"/></i18n:time>
                <xsl:text> - </xsl:text>
            </xsl:if>
            <xsl:value-of select="../@title"/>
        </p>
    </xsl:template>
    
</xsl:stylesheet>
