<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="http://exslt.org/math" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                extension-element-prefixes="math ametys resolver">

    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:syndication://pages/services/feed/common.xsl"/>
    <xsl:import href="service:syndication://pages/services/feed/utils/preference.xsl"/>
    
    <xsl:param name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">syndication syndication-columns</xsl:variable>
    <xsl:variable name="is-empty" select="not(/rssFeeds/feed) and not(/rssFeeds/feed-conf) and not(/rssFeeds/feed-error) and not(/rssFeeds/feed-error-custom)"/>
    <xsl:variable name="common-service-name">service-syndication</xsl:variable>    


    <xsl:variable name="raw-is-title-visible">        
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:variable>    
    <xsl:variable name="is-title-visible" select="string-length($raw-is-title-visible) &gt; 0"/>
  
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>                    
        </xsl:call-template>
    </xsl:template> 
    
    <!-- Used in common.xsl --> 
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <!-- Link to edit user RSS feed preferences -->
        <xsl:call-template name="feed-config-link"/>
        
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <xsl:if test="ametys:renderingContext() = 'back'">
            <link href="{ametys:pluginResourceURL('syndication', 'css/bo-error.css')}" rel="stylesheet" type="text/css" />
        </xsl:if>    
    </xsl:template> 
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <!-- Handle my RSS feed form -->
        <xsl:call-template name="feed-config-form" />
        
        <xsl:call-template name="link-top" />
        <div>
            <!-- Errors on customs feed -->
            <xsl:if test="/rssFeeds/feed-error-custom">
                <div class="error">
                    <ul>
                        <xsl:for-each select="/rssFeeds/feed-error-custom">
                            <xsl:call-template name="feed-error-custom" />
                        </xsl:for-each>
                    </ul>
                </div>
            </xsl:if>
            
            <xsl:if test="/rssFeeds/feed|/rssFeeds/feed-error">
                <ul class="feed-list">
                    <xsl:for-each select="/rssFeeds/feed|/rssFeeds/feed-error">
                        <li>
                            <xsl:attribute name="class"><xsl:call-template name="common-utils-class" /><xsl:if test="position() mod 3 = 1"><xsl:text> first-li</xsl:text></xsl:if></xsl:attribute>
        
                            <xsl:choose>
                                <xsl:when test="@url">
                                    <!-- Feed in error (only in BO mode) -->
                                    <xsl:call-template name="feed-error" />
                                </xsl:when>
                                <xsl:otherwise>
                                    <!-- <xsl:apply-templates select="image"/> -->
                                    <xsl:call-template name="syndication-title" />
                                    <!-- <xsl:call-template name="syndication-description"/> -->
                                    <xsl:call-template name="syndication-list" />
                                </xsl:otherwise>
                            </xsl:choose>
                        </li>
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </div>
        <xsl:call-template name="link-bottom" />
    </xsl:template>
    
    <!-- RSS feed title -->    
    <xsl:template name="syndication-title">
        <h2 class="rss-title">
            <xsl:choose>
                <xsl:when test="/rssFeeds/feed-conf[@feedUrl = current()/@feedUrl]/@feedName != ''"><xsl:value-of select="/rssFeeds/feed-conf[@feedUrl = current()/@feedUrl]/@feedName"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
            </xsl:choose>
        </h2>
    </xsl:template>        

    <!-- RSS feed description -->
    <xsl:template name="syndication-description">
        <p class="description"><xsl:value-of select="@description"/></p>
    </xsl:template>
    
    <!-- RSS feed items -->
    <xsl:template name="syndication-list">
        <xsl:if test="entry">
            <ul class="rss-items">
                <xsl:apply-templates select="entry"/>
            </ul>    
        </xsl:if>
    </xsl:template>    
            
    <!-- RSS feed entry -->    
    <xsl:template match="entry"> 
        <li>
            <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
            
            <xsl:call-template name="item-title"/>
            <xsl:call-template name="item-date"/>
        </li>
    </xsl:template>

    <!-- Title of RSS entry -->
    <xsl:template name="item-title">
        <p>
           <strong>
            <xsl:choose>
                <xsl:when test="@link">
                    <a href="{@link}"><xsl:value-of select="@title"/></a>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="@title"/></xsl:otherwise>
            </xsl:choose>
           </strong>
        </p>
    </xsl:template>
    
</xsl:stylesheet>
