<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="http://exslt.org/math" 
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                extension-element-prefixes="math ametys resolver">
         
    <xsl:template name="form-submit-url">
        <xsl:value-of select="concat(ametys:siteUriPrefix(), '/', ametys:lang(), '/_plugins/syndication/page/set-user-prefs')"/>
    </xsl:template>            

    <xsl:template name="configure-links-btn-text">
        <i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG" i18n:catalogue="plugin.syndication"/>
    </xsl:template>

    <xsl:template name="configure-links-btn">
	    <p class="feed-config-link" id="feed-config-header-{$uniqueId}"><xsl:call-template name="configure-links-btn-text"/></p>
	    <script type="text/javascript">
	        $j("#feed-config-header-<xsl:value-of select="$uniqueId"/>").wrapInner("&lt;a class='config' href='javascript: feed_config_form_popup_<xsl:value-of select="$uniqueId"/>()'&gt;&lt;/a&gt;")
	    </script>
    </xsl:template>
    
    <xsl:template name="feed-config-link">
        <xsl:if test="/rssFeeds/@showForm = 'true'">
            <xsl:call-template name="configure-links-btn" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="feed-config-form">
        <xsl:if test="/rssFeeds/@showForm = 'true'">
	        <xsl:variable name="form-submit-url"><xsl:call-template name="form-submit-url"/></xsl:variable>
            
	        <div class="feed-config-form">
	            
                <div id="feed-config-form-{$uniqueId}">
    	            <form id="feed-config-{$uniqueId}" action="{$form-submit-url}" method="post">
	                    <div class="feed-config-form">
				            <p>
	                            <xsl:choose>
	                                <xsl:when test="/rssFeeds/@nbMax != 0 and /rssFeeds/@nbMax != ''">
	                                    <i18n:translate>
	                                        <i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG_INFO_LIMIT" i18n:catalogue="plugin.syndication"/>
	                                        <i18n:param><xsl:value-of select="/rssFeeds/@nbMax"/></i18n:param>
	                                    </i18n:translate>
	                                </xsl:when>
	                                <xsl:otherwise><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG_INFO_NO_LIMIT" i18n:catalogue="plugin.syndication"/></xsl:otherwise>
	                            </xsl:choose>
				            </p>
				            <noscript>
				               <p>
				                   <i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG_INFO_FEED_MAX" i18n:catalogue="plugin.syndication"/><xsl:value-of select="/rssFeeds/@nbMax" />
				               </p>
				            </noscript>
		                    <input type="hidden" name="zone-item-id" id="zone-item-id-{$uniqueId}" value="{/rssFeeds/@zoneItemId}"/>
		                    <input type="hidden" name="nbMaxCheck" id="nb-max-check-{$uniqueId}" value="{/rssFeeds/@nbMax}"/>
		                    <input type="hidden" name="nbFeedService" id="nb-feed-service-{$uniqueId}" value="{/rssFeeds/@nbFeedService}"/>
		                    <input type="hidden" name="nbMaxUser" id="nb-max-user-{$uniqueId}" value="{/rssFeeds/@nbMaxUser}"/>
		                    <xsl:for-each select="/rssFeeds/feed-conf">
		                            <xsl:if test="@isCustom = 'false'">
		                                <xsl:call-template name="feed-config-form-feeds">
		                                    <xsl:with-param name="position" select="position()"/>
		                                </xsl:call-template>
		                            </xsl:if>
		                    </xsl:for-each>
		                    <br/>
		                    <xsl:if test="count(/rssFeeds/feed-conf[@isCustom = 'true']) != 0">
			                    <p><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CONFIG_INFO2" i18n:catalogue="plugin.syndication"/></p>
			                    <xsl:for-each select="/rssFeeds/feed-conf">
			                            <xsl:if test="@isCustom = 'true'">
			                                <xsl:call-template name="feed-config-form-feeds-custom">
			                                    <xsl:with-param name="position" select="position()"/>
			                                </xsl:call-template>
			                            </xsl:if>
			                    </xsl:for-each>
		                    </xsl:if>
		                    <div class="feed-config-form-bottom"></div>
	                    </div>
		            </form>
                </div>
	            
	            <xsl:call-template name="feed-form-script"/>
	        </div>
	   </xsl:if>
    </xsl:template>
    
    <xsl:template name="feed-config-form-feeds">
        <xsl:param name="position" />
        <xsl:variable name="name">
	        <xsl:choose>
	            <xsl:when test="@feedName != ''">
	                <xsl:value-of select="@feedName"/>
	            </xsl:when>
	            <xsl:otherwise>
	                <xsl:value-of select="@feedUrl"/>
	            </xsl:otherwise>
	        </xsl:choose>
        </xsl:variable>
        <div class="field checkbox">
            <div class="input">
                <input type="checkbox" name="feed-check-{$position}" id="feed-config-{$uniqueId}-check-{$position}">
                    <xsl:if test="@isSelected = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                </input>
                <input type="hidden" name="feed-id-{$position}" id="feed-config-{$uniqueId}-id-{$position}" value="{@feedId}"/>
            </div>
            <div class="label">
                <label for="feed-config-{$uniqueId}-check-{$position}"><xsl:value-of select="$name"/></label>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="feed-config-form-feeds-custom">
        <xsl:param name="position" />
        <div class="field checkbox">
            <div class="input">
                <input type="checkbox" name="feed-check-{$position}" id="feed-config-{$uniqueId}-check-{$position}">
                    <xsl:if test="@isSelected = 'true'"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                </input>
                <input type="hidden" name="feed-id-{$position}" id="feed-config-{$uniqueId}-id-{$position}" value="{@feedId}"/>
            </div>
            <div class="label">
                <input type="input" onkeyup="check_{$uniqueId}('feed-config-{$uniqueId}-check-{$position}')" name="feed-url-{$position}" id="feed-config-{$uniqueId}-url-{$position}" value="{@feedUrl}"/>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="feed-form-script">
        <script type="text/javascript">
            function check_<xsl:value-of select="$uniqueId"/>(id)
            {
                var checkBox = $j("#" + id);
                if (!checkBox[0].checked)
                {
                    checkBox[0].click()
                }
            }
        
            function feed_config_form_popup_<xsl:value-of select="$uniqueId"/>()
            {
                $j("#feed-config-form-<xsl:value-of select="$uniqueId"/> script").remove();
                
                // Reset form to initial state
                $j("#feed-config-<xsl:value-of select="$uniqueId"/>")[0].reset();
                // Open the dialog box
                $j("#feed-config-form-<xsl:value-of select="$uniqueId"/>").dialog('open');
            }
            
            function feed_config_form_submit_<xsl:value-of select="$uniqueId"/>()
            {
                var nbMaxCheck = <xsl:value-of select="/rssFeeds/@nbMax"/>;
                var nbMaxUser = <xsl:value-of select="/rssFeeds/@nbMaxUser"/>;
                var nbFeedService = <xsl:value-of select="/rssFeeds/@nbFeedService"/>;
                if (!checkNbFeed_<xsl:value-of select="$uniqueId"/>(nbMaxCheck) &amp;&amp; nbMaxCheck != 0)
                {
                    alert("<i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_ERROR_TO_MANY_CHECK" i18n:catalogue="plugin.syndication"/>");
                    return false;
                }
                else
                {
                    var i = 1;
                    var checkBox = $j("#feed-config-<xsl:value-of select="$uniqueId"/>-check-" + i);
                    var zoneItemInput = $j("#zone-item-id-<xsl:value-of select="$uniqueId"/>");
                    
                    var data = {
                        "ajax": "true",
                        "zone-item-id": zoneItemInput.val(),
                        "nbMaxCheck": nbMaxCheck,
                        "nbFeedService": nbFeedService,
                        "nbMaxUser": nbMaxUser
                    };
                    
                    while (checkBox[0] != null)
                    {
                        data["feed-check-" + i] = checkBox[0].checked;
                        
                        var idFeedInput = $j("#feed-config-<xsl:value-of select="$uniqueId"/>-id-" + i);
                        data["feed-id-" + i] = idFeedInput[0].value;
                        
                        var inputUrl = $j("#feed-config-<xsl:value-of select="$uniqueId"/>-url-" + i);
                        if (inputUrl[0] != null)
                        {
                            data["feed-url-" + i] = inputUrl[0].value;
                        }
                        i++;
                        checkBox = $j("#feed-config-<xsl:value-of select="$uniqueId"/>-check-" + i);
                    }
                  
                    // send it in ajax
                    function result(data)
                    {
                        var s = "";
                        $j('errors error', data).each(function () { s += $j(this).text() + "\n"; });
                        
                        if (s == "")
                        {
                            var errors = $j('error > error', data);
                            if (errors.length == 0)
                            {
                                $j("#feed-config-form-<xsl:value-of select="$uniqueId"/>").dialog( "close" );
                                alert("<i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_OK" i18n:catalogue="plugin.syndication"/>");
                                location.reload();
                            }
                            else
                            {
                                var errorInfo = "";
                                errors.each(function() {
                                    errorInfo += $j(this).text();
                                }); 
                                alert(errorInfo)
                            }
                        }
                        else
                        {
                            alert(s);
                        }
                    }
                    
                    function handleError(jqXHR, textStatus, errorThrown)
                    {
                        alert("<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_FORM_ERROR_AJAX" i18n:catalogue="plugin.cms"/>");
                    }
                    
                    $j.ajax({
                        url: "<xsl:value-of select="$uri-prefix"/>/plugins/syndication/set-user-prefs",
                        data: data,
                        type: 'post',
                        success: result,
                        error: handleError
                    });
                }
            }
            
            function checkNbFeed_<xsl:value-of select="$uniqueId"/>(nbMaxCheck)
            {
               var i = 1;
               var checkBox = $j("#feed-config-<xsl:value-of select="$uniqueId"/>-check-" + i);
               
               var nbCheck = 0;
               while (checkBox[0] != null)
               {
                    if (checkBox[0].checked)
                    {
                        nbCheck++;
                    }
                    i++;
                    checkBox = $j("#feed-config-<xsl:value-of select="$uniqueId"/>-check-" + i);
               }
               
               return !(nbCheck > nbMaxCheck);
            }
            
            $j( document ).ready(function() {
	            $j("#feed-config-form-<xsl:value-of select="$uniqueId"/>").dialog({
	                  autoOpen: false,
                      resizable: false,
	                  height:'410',
	                  width: '380',
	                  modal: true,
	                  title: '<i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_TITLE" i18n:catalogue="plugin.syndication"/>',
	                  buttons: {
	                    <i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_RECORD" i18n:catalogue="plugin.syndication"/>: function() {
	                      feed_config_form_submit_<xsl:value-of select="$uniqueId"/>();
	                    },
	                    <i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_POPUP_CANCEL" i18n:catalogue="plugin.syndication"/>: function() {
	                      $j( this ).dialog( "close" );
	                    }
	                  }
	                });
            });
        </script>
    </xsl:template> 
                
</xsl:stylesheet>