<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
	
	<xsl:template match="/ActionResult">
		<html>
			<head/>
			
			<body id="default">
				<xsl:choose>
					<xsl:when test="error">
						<div class="form-errors">
							<h1><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_ERROR" i18n:catalogue="plugin.syndication"/></h1>
							<p><xsl:value-of select="error"/></p>
							<noscript>
								<p><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_BACK_ALT" i18n:catalogue="plugin.syndication"/></p>
							</noscript>
							<script type="text/javascript">
								document.write("&lt;p&gt;&lt;a href='javascript: history.back();'&gt;<i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_BACK" i18n:catalogue="plugin.syndication"/>&lt;/a&gt;&lt;/p&gt;")
							</script>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<div class="form-message">
							<h1><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_SUCCESS" i18n:catalogue="plugin.syndication"/></h1>
							<noscript>
								<p><i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_BACK_ALT_SUCCESS" i18n:catalogue="plugin.syndication"/></p>
							</noscript>
							<script type="text/javascript">
								document.write("&lt;p&gt;&lt;a href='javascript: history.back();'&gt;<i18n:text i18n:key="SYNDICATION_SERVICE_CONFIG_RSS_FORM_BACK" i18n:catalogue="plugin.syndication"/>&lt;/a&gt;&lt;/p&gt;")
							</script>
						</div>							
					</xsl:otherwise>
				</xsl:choose>
			</body>
		</html>
	</xsl:template>
	
</xsl:stylesheet>